/*----------------------------------------------------------------------------*/
/* TP1: STRUCTURES                                                      TP1.C */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* HEADERS */

#include "tp1.h"

/*----------------------------------------------------------------------------*/
/* 1 */
/* Titre: afficherFilm
   Entrees: un film "f".
   Finalite: afficher les differents champs du film.
   Sortie: aucune.
   Hypotheses: aucune.
   Conclusions: aucune.
   Strategie: evidente.
   Variables inter: aucune.
   Fonctions utilisees: aucune.
*/

void afficherFilm(FILM f)
{ printf("%s, %s, %d, %d\n",f.titre,f.realisateur,f.annee,f.duree); }

/*----------------------------------------------------------------------------*/
/* 2 */
/* Titre: saisirFilm
   Entrees: un pointeur "f" sur un film.
   Finalite: saisir les differents champs du film.
   Sortie: aucune.
   Hypotheses: aucune.
   Conclusions: aucune.
   Strategie: evidente.
   Variables inter: aucune.
   Fonctions utilisees: "fflush(stdin)" qui nettoie le buffer
                        du clavier.
*/

void saisirFilm(FILM * f) {
 printf("Titre: ");
 fflush(stdin);
 scanf("%s",f->titre);
 printf("Realisateur: ");
 fflush(stdin);
 scanf("%s",f->realisateur);
 printf("Annee: ");
 fflush(stdin);
 scanf("%d",&(f->annee));
 printf("Duree: ");
 fflush(stdin);
 scanf("%d",&(f->duree));
}

/*----------------------------------------------------------------------------*/
/* 3 */
/* Titre: saisirTableauFilms
   Entrees: un tableau "t" de films,
            un pointeur "n" sur la taille du tableau.
   Finalite: saisir un tableau de films.
   Sortie: aucune.
   Hypotheses: aucune.
   Conclusions: aucune.
   Strategie: demande a l'utilisateur le nombre de films
              qu'il souhaite saisir.
              parcours le tableau et a chaque case, execute la
              fonction de saisie d'un film.
   Variables inter: "i" un indice pour parcourir le tableau.
   Fonctions utilisees: "saisirFilm".
*/

void saisirTableauFilms(FILM * t, int * n) {
 int i = 0;

 printf("Combien de films ? ");
 fflush(stdin);
 scanf("%d",n);
 printf("\n");

 while (i < *n) {
  printf("Film %d\n",i);
  saisirFilm(&t[i]);
  i++;
  if (i < *n) printf("\n");
 }
}

/*----------------------------------------------------------------------------*/
/* 4 */
/* Titre: afficherTableauFilms
   Entrees: un tableau "t" de films,
            la taille "n" du tableau.
   Finalite: afficher le tableau de films.
   Sortie: aucune.
   Hypotheses: aucune.
   Conclusions: aucune.
   Strategie: parcours le tableau et a chaque case, execute la
              fonction d'affichage d'un film.
   Variables inter: "i" un indice pour parcourir le tableau.
   Fonctions utilisees: "afficherFilm".
*/

void afficherTableauFilms(FILM * t, int n) {
 int i = 0;

 while (i < n) {
  printf("Film %d: ",i);
  afficherFilm(t[i]);
  i++;
 }
}

/*----------------------------------------------------------------------------*/
/* 5 */
/* Titre: ecrireFilm
   Entrees: un fichier "f",
            un film "a".
   Finalite: ecrire dans "f" les differents champs de "a".
   Sortie: aucune.
   Conclusion: aucune.
   Strategie: evidente.
   Variables inter: aucune.
   Fonctions utilisees: aucune.
*/

void ecrireFilm(FICHIER f, FILM a)
{ fprintf(f,"%s %s %d %d\n",a.titre,a.realisateur,a.annee,a.duree); }

/*----------------------------------------------------------------------------*/
/* 6 */
/* Titre: lireFilm
   Entrees: un fichier "f",
            un pointeur "a" sur un film.
   Finalite: lire dans "f" les champs du film pointe par "e".
   Sortie: aucune.
   Hypotheses: aucune.
   Conclusions: aucune.
   Strategie: evidente.
   Variables inter: aucune.
   Fonctions utilisees: aucune.
*/

void lireFilm(FICHIER f, FILM * a)
{ fscanf(f,"%s %s %d %d",a->titre,a->realisateur,&(a->annee),&(a->duree)); }

/*----------------------------------------------------------------------------*/
/* 7 */
/* Titre: lireTableauFilms
   Entrees: un fichier "f",
            un tableau "t" de films,
            un pointeur sur la taille "n" du tableau.
   Finalite: remplir le tableau de films a partir de "f".
   Sortie: aucune.
   Hypotheses: aucune.
   Conclusions: aucune.
   Strategie: lit la taille du tableau dans "f".
              parcours le tableau et a chaque case, execute la
              fonction de lecture d'un film.
   Variables inter: "i" un indice pour parcourir le tableau.
   Fonctions utilisees: "lireFilm".
*/

void lireTableauFilms(FICHIER f, FILM * t, int * n) {
 int i = 0;

 fscanf(f,"%d",n);

 while (i < *n) {
  lireFilm(f,&t[i]);
  i++;
 }
}

/*----------------------------------------------------------------------------*/
/* 8 */
/* Titre: ecrireTableauFilms
   Entrees: un fichier "f",
            un tableau "t" de films,
            la taille "n" du tableau.
   Finalite: ecrire dans "f" le tableau "t".
   Hypotheses: aucune.
   Conclusions: aucune.
   Strategie: ecrit la taille du tableau.
              parcours le tableau et a chaque case, execute la
              fonction d'ecriture d'un film.
   Variables inter: "i" un indice pour parcourir le tableau.
   Fonctions utilisees: "ecrireFilm".
*/

void ecrireTableauFilms(FICHIER f, FILM * t, int n) {
 int i = 0;

 fprintf(f,"%d\n\n",n);

 while (i < n) {
  ecrireFilm(f,t[i]);
  i++;
 }
}

/*----------------------------------------------------------------------------*/
/* FIN */

