/*----------------------------------------------------------------------------*/
/* TP1: STRUCTURES                                                      TP1.H */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* gardien */

#ifndef TP1_H
#define TP1_H

/*----------------------------------------------------------------------------*/
/* HEADERS */

#include "commun.h"

/*----------------------------------------------------------------------------*/
/* TYPES */

typedef struct {
 char titre[50];
 char realisateur[50];
 int  annee;
 int  duree;
}
FILM;

/*----------------------------------------------------------------------------*/
/* PROTOTYPES */

/* 1 */ /* Affiche les informations sur un film. */

void afficherFilm(FILM f);

/* 2 */ /* Saisit les informations sur un film. */

void saisirFilm(FILM * f);

/* 3 */ /* Saisit un tableau de films. */

void saisirTableauFilms(FILM * t, int * n);

/* 4 */ /* Affiche le contenu d'un tableau de films. */

void afficherTableauFilms(FILM * t, int n);

/* 5 */ /* Ecrit les informations sur un film dans un fichier. */

void ecrireFilm(FICHIER f, FILM a);

/* 6 */ /* Lit les informations sur un film a partir d'un fichier. */

void lireFilm(FICHIER f, FILM * a);

/* 7 */ /* Lit un tableau de films a partir d'un fichier. */

void lireTableauFilms(FICHIER f, FILM * t, int * n);

/* 8 */ /* Ecrit un tableau de films dans un fichier. */

void ecrireTableauFilms(FICHIER f, FILM * t, int n);

/*----------------------------------------------------------------------------*/
/* FIN */

#endif

