//==============================================================================
// T P 1                                                                 Classe
// F i l m  
//==============================================================================

// Cette classe represente un film.

// Package //-------------------------------------------------------------------
package tp1;

// Importation //---------------------------------------------------------------
import entreeSortie.*;

// Classe  F i l m //-----------------------------------------------------------
public class Film {
 //--------------------------------------------------------------------Attributs
 public String titre;
 public String realisateur;
 public int    annee;
 public int    duree;
 //-----------------------------------------------------------------Constructeur
 // Finalite: construire un film.
 //
 public Film() {
  titre = "";
  realisateur = "";
  annee = 1900;
  duree = 0;
 }
 //---------------------------------------------------------------------Afficher
 // Finalite: afficher les differents attributs du film.
 // 
 public void afficher() {
  Ecran.ecrire(titre + " - " + realisateur + " - " + annee + " - " + duree);
  Ecran.ecrire("\n");
 }
 //-----------------------------------------------------------------------Saisir
 // Finalite: saisir les differents attributs du film.
 //
 public void saisir() {
  Ecran.ecrire("Titre: ");
  titre = Clavier.lireChaine();
  
  if (titre.equals("")) {
   realisateur = "";
   annee = 1900;
   duree = 0;
  }
  else {
   Ecran.ecrire("Realisateur: ");
   realisateur = Clavier.lireChaine();
   Ecran.ecrire("Annee: ");
   annee = Clavier.lireEntier();
   Ecran.ecrire("Duree: ");
   duree = Clavier.lireEntier();
  }
 }
 //-----------------------------------------------------------------------Ecrire
 // Entrees: un fichier "f".
 // Finalite: ecrire dans "f" les differents attributs.
 //
 public void ecrire(FichierSortie f) {
  f.ecrire(titre + "\n");
  f.ecrire(realisateur + "\n");
  f.ecrire(annee  + " " + duree);
  f.ecrire("\n");
 }
 //-------------------------------------------------------------------------Lire
 // Entrees: un fichier "f".
 // Finalite: lire dans "f" les attributs du film.
 //
 public void lire(FichierEntree f) {
  titre = f.lireLigne();
  realisateur = f.lireLigne();
  annee = f.lireEntier();
  duree = f.lireEntier();
 }
}

// Fin //-----------------------------------------------------------------------
