//==============================================================================
// T P 1                                                                 Classe
// V i d e o t h e q u e 
//==============================================================================

// Cette classe represente une videotheque.

// Package //-------------------------------------------------------------------
package tp1;

// Importation //---------------------------------------------------------------
import entreeSortie.*;

public class Videotheque {
 //--------------------------------------------------------------------Attributs
 protected int  taille;
 protected Film tableau[];
 //-----------------------------------------------------------------Constructeur
 // Entrees: Taille maximale "n" de la videotheque.
 // Finalite: Construire une videotheque d'une taille maximale donnee.
 //
 public Videotheque(int n) {
  taille = n;
  tableau = new Film[n];
 }
 //-----------------------------------------------------------------------Saisir
 // Finalite: saisir un tableau de films.
 // Strategie: demande a l'utilisateur le nombre de films
 //            qu'il souhaite saisir.
 //            parcours le tableau et a chaque case, execute la
 //            fonction de saisie d'un film.
 //  Variables inter: "i" un indice pour parcourir le tableau.
 //
 public void saisir() {
  String c;
  boolean encore = (tableau.length > 0);
 
  taille = 0;

  while (encore) {
   Ecran.ecrire("Film " + taille + "\n");
   tableau[taille] = new Film();
   tableau[taille].saisir();
   
   if (tableau[taille].titre.equals(""))
    encore = false;
   else {
    taille++;
    encore = (taille < tableau.length);
   }

   Ecran.ecrire("\n");
  }
 }
 //---------------------------------------------------------------------Afficher
 // Finalite: afficher le tableau de films.
 // Strategie: parcours le tableau et a chaque case, execute la
 //            fonction d'affichage d'un film.
 // Variables inter: "i" un indice pour parcourir le tableau.
 //
 public void afficher() {
  int i = 0;

  while (i < taille) {
   Ecran.ecrire("Film " + i + ": ");
   tableau[i].afficher();
   i++;
  }
 }
 //-------------------------------------------------------------------------Lire
 // Entrees: un fichier "f".
 // Finalite: remplir le tableau de films a partir de "f".
 // Strategie: lit la taille du tableau dans "f".
 //            parcours le tableau et a chaque case, execute la
 //            fonction de lecture d'un film.
 // Variables inter: "i" un indice pour parcourir le tableau.
 //
 public void lire(FichierEntree f) {
  int i = 0;

  taille = f.lireEntier();

  while (i < taille) {
   tableau[i] = new Film();
   tableau[i].lire(f);
   i++;
  }
 }
 //-----------------------------------------------------------------------Ecrire
 // Entrees: un fichier "f".
 // Finalite: ecrire dans "f" le tableau de films.
 // Strategie: ecrit la taille du tableau.
 //            parcours le tableau et a chaque case, execute la
 //            fonction d'ecriture d'un film.
 // Variables inter: "i" un indice pour parcourir le tableau.
 // Fonctions utilisees: "ecrireFilm".
 //
 public void ecrire(FichierSortie f) {
  int i = 0;

  f.ecrire(taille + "\n\n");

  while (i < taille) {
   tableau[i].ecrire(f);
   i++;
   if (i < taille) f.ecrire("\n");
  }
 }
}

// Fin //-----------------------------------------------------------------------
