//==============================================================================
// S t r u c t u r e s                                                Interface
// C o m p a r e r
//                                                           Par Bruno Bachelet
//==============================================================================
// Copyright (c) 1999-2016
// Bruno Bachelet - bruno@nawouak.net - http://www.nawouak.net
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the license, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details (http://www.gnu.org).

// Cette interface decrit la comparaison de deux objets. Elle est utilisee
// pour permettre a une structure de donnees d'organiser des objets d'un
// certain type, alors que la structure ne connait pas, a priori, le type des
// objets qu'elle manipule.

// Package //-------------------------------------------------------------------
package structures;

// Interface  C o m p a r e r //------------------------------------------------
public interface Comparer {
 //-------------------------------------------------------------------------Egal
 // Finalite: retourner "VRAI" si les deux objets sont egaux.
 //
 public boolean egal(Object a,Object b);
 //--------------------------------------------------------------------Inferieur
 // Finalite: retourner "VRAI" si le premier objet est inferieur au second.
 //
 public boolean inferieur(Object a,Object b);
}

// Fin //-----------------------------------------------------------------------
