//==============================================================================
// S t r u c t u r e s                                                   Classe
// T r i T a b l e a u
//                                                           Par Bruno Bachelet
//==============================================================================
// Copyright (c) 1999-2016
// Bruno Bachelet - bruno@nawouak.net - http://www.nawouak.net
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the license, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details (http://www.gnu.org).

// Cette classe regroupe des algorithmes de tri de tableau.

// Package //-------------------------------------------------------------------
package structures;

// Importation //---------------------------------------------------------------
import entreeSortie.*;

// Classe T r i T a b l e a u //------------------------------------------------
public class TriTableau {
 //-------------------------------------------------------------------Attributes
 protected Comparer comparer; // Permet de comparer deux elements du tableau.
 //-----------------------------------------------------------------Constructeur
 // Entrees: un object de comparaison.
 // Finalite: construire un objet de tri de tableau.
 //
 public TriTableau(Comparer comparer_) {
  comparer = comparer_;
 }
 //---------------------------------------------------------------TrierSelection
 // Entrees: un tableau d'elements "t",
 //          sa taille "n".
 // Finalite: trier le tableau "t" de "n" elements avec la methode par
 //           selection.
 // Variables inter: deux entiers "i" et "j" pour parcourir le tableau,
 //                  un element "tmp" pour la permutation de deux elements.
 //
 public void trierSelection(Object t[], int n) {
  int i = 0;
  int j;
  Object tmp;

  while (i < n - 1) {
   j = i + 1;

   while (j < n) {
    if (comparer.inferieur(t[j],t[i])) {
     tmp = t[j];
     t[j] = t[i];
     t[i] = tmp;
    }

    j++;
   }

   i++;
  }
 }
 //------------------------------------------------------------------TrierFusion
 // Entrees: un tableau d'elements "t",
 //          sa taille "n".
 // Finalite: trier le tableau "t" de "n" elements avec la methode par fusion.
 // Variables inter: deux tableaux "t1" et "t2" qui representent les deux
 //                  moities du tableau "t",
 //                  un entier "n1" pour la taille du tableau "t1".
 //
 public void trierFusion(Object t[], int n) {
  int    n1 = n / 2;
  Object t1[];
  Object t2[];

  if (n > 1) {
   t1 = new Object[n1];
   t2 = new Object[n - n1];

   if (t1 != null && t2 != null) {
    scinder(t,n,t1,n1,t2);
    trierFusion(t1,n1);
    trierFusion(t2,n - n1);
    fusionner(t,t1,n1,t2,n - n1);
   }
   else {
    Ecran.ecrire("Erreur: Pas assez de memoire !");
    System.exit(1);
   }
  }
 }
 //----------------------------------------------------------------------Scinder
 // Entrees: un tableau "t",
 //          sa taille "n",
 //          un tableau "t1",
 //          sa taille "n1",
 //          un tableau "t2".
 // Finalite: Scinde le tableau "t" en deux moities stockees dans les
 //           tableaux "t1" et "t2".
 // Hypotheses: "t2" a la taille suffisante pour accueillir une moitie de "t".
 // Variables inter: deux entiers "i" et "j" pour parcourir les tableaux.
 //
 protected void scinder(Object t[], int n, Object t1[], int n1, Object t2[]) {
  int i = 0;
  int j = 0;

  while (i < n1) {
   t1[i] = t[i];
   i++;
  }

  while (i < n) {
   t2[j] = t[i];
   i++;
   j++;
  }
 }
 //-------------------------------------------------------------------Concatener
 // Entrees: un tableau "t1",
 //          sa taille "n1",
 //          un tableau "t2",
 //          sa taille "n2",
 //          un indice i2.
 // Finalite: copie le tableau "t2" a la fin du tableau "t1", a partir de
 //           l'indice "i2" de "t2".
 // Sortie: nouvelle taille du tableau "t1".
 // Hypotheses: le tableau "t1" a suffisamment de cases pour accueillir les
 //             elements de "t2".
 // Variables inter: un entier "i" qui parcours le tableau "t2".
 //
 protected int concatener(Object t1[], int n1, Object t2[], int n2, int i2) {
  int i = 0;

  while (i < n2) {
   t1[n1] = t2[i2 + i];
   n1++;
   i++;
  }

  return n1;
 }
 //--------------------------------------------------------------------Fusionner
 // Entrees: un tableau "t",
 //          un tableau "t1",
 //          sa taille "n1",
 //          un tableau "t2",
 //          sa taille "n2".
 // Finalite: fusionne deux tableaux tries "t1" et "t2" en un seul "t"
 //           egalement trie.
 // Variables inter: trois entiers "i1", "i2" et "i" pour parcourir les
 //                  tableaux.
 //
 protected void fusionner(Object t[], Object t1[], int n1, Object t2[],
                          int n2) {
  int i = 0;
  int i1 = 0;
  int i2 = 0;

  while (i1 < n1 && i2 < n2) {
   if (comparer.inferieur(t1[i1],t2[i2])) {
    t[i] = t1[i1];
    i1++;
   }
   else {
    t[i] = t2[i2];
    i2++;
   }

   i++;
  }

  i = concatener(t,i,t1,n1 - i1,i1);
  concatener(t,i,t2,n2 - i2,i2);
 }
}

// Fin //-----------------------------------------------------------------------
