/*----------------------------------------------------------------------------*/
/* TP3: LISTES CHAINEES                                                 TP3.C */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* HEADERS */

#include "tp3.h"

/*----------------------------------------------------------------------------*/
/* R E M A R Q U E                                                            */
/*                                                                            */
/* Il n'y a pas de fichier pour les tests.                                    */
/* Les fonctions ecrites pour realiser le TP suffisent pour verifier que      */
/* chaque fonction est correcte.                                              */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* 1 */
/* Titre: ajouterFait
   Entrees: un pointeur "l" sur une liste de faits,
            un pointeur "p" sur un fait.
   Finalite: ajouter le fait pointe par "p" en tete de la liste "l".
   Variables inter: un pointeur "p2" sur un fait.
*/

void ajouterFait(FAIT ** l, FAIT * p) {
 FAIT * p2 = *l;
 
 *l = p;
 p->suiv = p2;
}

/*----------------------------------------------------------------------------*/
/* 2 */
/* Titre: ajouterRegle
   Entrees: un pointeur "l" sur une liste de regles,
            un pointeur "p" sur une regle.
   Finalite: ajouter la regle pointee par "p" en tete de la liste "l".
   Variables inter: un pointeur "p2" sur une regle.
*/

void ajouterRegle(REGLE ** l, REGLE * p) {
 REGLE * p2 = *l;
 
 *l = p;
 p->suiv = p2;
}

/*----------------------------------------------------------------------------*/
/* 3 */
/* Titre: lireBaseFaits
   Entrees: un fichier "f",
            un tableau de chaines de caracteres "b",
            un pointeur "n" sur sa taille logique.
   Finalite: lire dans "f" une base de faits et les stocker dans le
             tableau "b".
   Variables inter: un booleen "ok" qui vaut "VRAI" tant qu'il reste un fait
                    a lire dans le fichier "f".
   Strategie: lire une ligne du fichier "f" jusqu'a trouver la chaine 
              de caracteres "<fin>".
*/

void lireBaseFaits(FILE * f, char b[50][256], int * n) {
 BOOLEEN ok = VRAI;
 
 *n = 0;
  
 while (ok) {
  fgets(b[*n],256,f);

  if (strcmp(b[*n],"<fin>") == 0) ok = FAUX;
  else (*n)++;
 }
}

/*----------------------------------------------------------------------------*/
/* 4 */
/* Titre: afficherBaseFaits
   Entrees: un tableau de chaines de caracteres "b",
            sa taille "n".
   Finalite: afficher les faits du tableau "b".
   Variables inter: un entier "i" pour parcourir le tableau.
*/

void afficherBaseFaits(char b[50][256], int n) {
 int i = 0;
 
 while (i < n) {
  printf("F%d: %s",i + 1,b[i]);
  i++;
 }
}

/*----------------------------------------------------------------------------*/
/* 5 */
/* Titre: lireRegle
   Entrees: un fichier "f",
            un pointeur "r" sur une regle.
   Finalite: lire dans le fichier "f" les donnees sur une regle et les stocke
             dans la regle "r".
   Sortie: renvoie "FAUX" s'il n'y a plus de regle a lire dans le fichier.
   Variables inter: un entier "i" pour compter les hypotheses et 
                    les conclusions,
                    un pointeur "p" sur un fait,
                    une chaine de caracteres "c" pour la lecture dans le
                    fichier.                    
   Strategie: lit les hypotheses et les ajoute dans la liste des hypotheses,
              lit les conclusions et les ajoute dans la liste des conclusions,
              la syntaxe pour une regle est la suivante:
                 4 & 3 & 2 => 1 & 8 ;
                 (les faits F4, F3 et F2 impliquent les faits F1 et F8).
*/

BOOLEEN lireRegle(FILE * f, REGLE * r) {
 char c[50];
 int i;
 FAIT * p;
 
 r->hyps = NULL;
 r->ccls = NULL;
 
 /* Lecture des hypotheses. */
 do {
  fscanf(f,"%d",&i);
  if (i == 0) return FAUX;
  p = ALLOUER(FAIT,1);
  p->suiv = NULL;
  p->id = i;
  ajouterFait(&(r->hyps),p);
  fscanf(f,"%s",c);  
 }
 while (strcmp(c,"=>") != 0);
 
 /* Lecture des conclusions. */
 do {
  fscanf(f,"%d",&i);
  p = ALLOUER(FAIT,1);
  p->suiv = NULL;
  p->id = i;
  ajouterFait(&(r->ccls),p);
  fscanf(f,"%s",c);
 }
 while (strcmp(c,";") != 0);
 
 return VRAI;
}   

/*----------------------------------------------------------------------------*/
/* 6 */
/* Titre: lireBaseRegles
   Entrees: un fichier "f",
            un pointeur "b" sur une liste de regles.
   Finalite: lire dans "f" une liste de regles et les stocker dans "b".
   Variables inter: un booleen "ok" qui vaut "VRAI" tant qu'il reste une regle
                    a lire dans le fichier "f",
                    un pointeur "p" sur une regle,
                    un entier "i" pour compter les regles.
*/

void lireBaseRegles(FILE * f, REGLE ** b) {
 int i = 1;
 BOOLEEN ok = VRAI;
 REGLE * p;
 
 *b = NULL;
 
 while (ok) {
  p = ALLOUER(REGLE,1);
  p->suiv = NULL;
  p->id = i;
  ok = lireRegle(f,p);
  
  if (!ok) LIBERER(p);
  else ajouterRegle(b,p);
 
  i++;
 }
}

/*----------------------------------------------------------------------------*/
/* 7 */
/* Titre: afficherListeFaits
   Entrees: une liste de faits "l".
   Finalite: afficher le contenu de la liste "l".
   Strategie: parcours la liste en affichant des informations sur chaque
              fait visite.
*/

void afficherListeFaits(FAIT * l) {
 while (l != NULL) {
  printf("F%d ",l->id);
  l = l->suiv;
 }
}

/*----------------------------------------------------------------------------*/
/* 8 */
/* Titre: afficherListeRegles
   Entrees: une liste de regles "l".
   Finalite: affiche le contenu de la liste "l".
   Sortie: aucune.
   Hypotheses: aucune.
   Conclusions: aucune.
   Variables inter: aucune.
   Strategie: parcours la liste en affichant des informations sur chaque
              regle visitee.
*/

void afficherListeRegles(REGLE * l) {
 while (l != NULL) {
  printf("R%d: ",l->id);
  afficherListeFaits(l->hyps);
  printf("=> ");
  afficherListeFaits(l->ccls);
  printf("\n"); 
  l = l->suiv;
 }
}

/*----------------------------------------------------------------------------*/
/* 9 */
/* Titre: saisirListeFaits
   Entrees: un pointeur "l" sur une liste de faits.
   Finalite: permettre a l'utilisateur de saisir une liste de faits.
   Variables inter: un entier "i" pour saisir le numero du fait,
                    un pointeur "p" sur un fait.
   Strategie: demande a l'utilisateur un numero de fait et l'ajoute
              dans la liste "l". Si le numero "0" est entre, alors
              la saisie est terminee.
*/

void saisirListeFaits(FAIT ** f) {
 int i;
 FAIT * p;
 
 *f = NULL;
 
 printf("Fait ? ");
 scanf("%d",&i);
 
 while (i != 0) {
  p = ALLOUER(FAIT,1);
  p->suiv = NULL;
  p->id = i;
  ajouterFait(f,p);
  printf("Fait ? ");
  scanf("%d",&i);
 }
}  

/*----------------------------------------------------------------------------*/
/* 10 */
/* Titre: faitPresent
   Entrees: une liste de faits "l",
            un entier "id" qui identifie un fait.
   Finalite: indiquer si le fait "id" est dans la liste "l".
   Sortie: "VRAI" si le fait "id" est present dans la liste "l".
   Variables inter: un booleen "trouve" qui indique si "id" a ete trouve
                    dans la liste.
   Strategie: parcours la liste "l" et compare l'identifiant de chaque fait
              visite avec "id".
*/

BOOLEEN faitPresent(FAIT * l, int id) {
 BOOLEEN trouve = FAUX;
 
 while (l != NULL && !trouve) {
  if (l->id == id) trouve = VRAI;
  l = l->suiv;
 }

 return trouve;
}

/*----------------------------------------------------------------------------*/
/* 11 */
/* Titre: appliquerRegle
   Entrees: un pointeur "l" sur une liste de faits,
            un pointeur "r" sur une regle.
   Finalite: appliquer la regle "r" si les faits dans "l" le permettent,
             les conclusions de "r" sont alors mises dans "l".
   Sortie: "VRAI" si la regle "r" a pu etre appliquee.
   Variables inter: un booleen "ok" qui indique si la regle peut etre
                    appliquee,
                    un pointeur "p" sur un fait pour parcourir la liste des
                    hypotheses et la liste des conclusions,
                    un pointeur "p2" sur un fait pour ajouter un fait dans la
                    liste des faits "l".
   Strategie: verifie d'abord que tous les faits de l'hypothese sont presents
              dans "l",
              si la regle est applicable, les faits de la conclusion sont
              ajoutes dans la liste "l".
*/

BOOLEEN appliquerRegle(FAIT ** l, REGLE * r) {
 BOOLEEN ok = VRAI;
 FAIT * p = r->hyps;
 FAIT * p2;
 
 /* Verifie que les hypotheses sont dans la liste de faits. */
 while (p != NULL && ok) {
  if (!faitPresent(*l,p->id)) ok = FAUX;
  p = p->suiv;
 }

 if (ok) {
  /* Ajoute les conclusions dans la liste des faits. */
  p = r->ccls;
  ok = FAUX;
 
  while (p != NULL) {
   if (!faitPresent(*l,p->id)) {
    p2 = ALLOUER(FAIT,1);
    p2->id = p->id;
    p2->suiv = NULL;
    ajouterFait(l,p2);
    ok = VRAI;
   }
   
   p = p->suiv;
  }
 }
 
 return ok;
}

/*----------------------------------------------------------------------------*/
/* 12 */
/* Titre: supprimerRegle
   Entrees: un pointeur "l" sur une liste de regles,
            un entier "id" qui identifie une regle.
   Finalite: supprimer la regle "id" de la liste "l".
   Variables inter: un pointeur "p" sur une regle pour parcourir la liste "l".
   Strategie: parcours la liste "l" pour trouver la regle d'identifiant "id",
              modifie les liens pour enlever la regle trouvee,
              libere la memoire occupee par la regle.
*/

void supprimerRegle(REGLE ** l, int id) {
 REGLE * p;

 while (*l != NULL && (*l)->id != id) {
  l = &((*l)->suiv);
 }
 
 if (*l != NULL) {
  p = *l;
  viderListeFaits(&(p->hyps));
  viderListeFaits(&(p->ccls));
  *l = (*l)->suiv;
  LIBERER(p);
 }
}

/*----------------------------------------------------------------------------*/
/* 13 */
/* Titre: afficherListeRegles2
   Entrees: une liste de regles "l".
   Finalite: afficher l'identifiant des regles de la liste "l".
   Strategie: parcours la liste en affichant l'identifiant de chaque
              regle visitee.
*/

void afficherListeRegles2(REGLE * l) {
 while (l != NULL) {
  printf("R%d ",l->id);
  l = l->suiv;
 }
}

/*----------------------------------------------------------------------------*/
/* 14 */
/* Titre: trouverConclusions
   Entrees: un pointeur "b" sur la base des regles,
            un pointeur "l" sur une liste des faits.
   Finalite: trouver toutes les conclusions qu'il est possible de deduire a
             partir de la liste des faits "l" en appliquant les regles de la
             base "b". 
   Variables inter: un booleen "trouve" qui indique si de nouveaux faits ont
                    ete trouves,
                    un pointeur "p" sur une regle.
   Strategie: tant que des nouveaux faits sont trouves, on parcours la liste
              des regles pour en trouver une qui soit applicable. Une fois
              appliquee, la regle est retiree de la base des regles.
*/

void trouverConclusions(REGLE ** b, FAIT ** l) {
 BOOLEEN trouve = VRAI;
 REGLE * p;

 printf("Faits: ");
 afficherListeFaits(*l);
 printf("\n");
 printf("Regles: ");
 afficherListeRegles2(*b);
 printf("\n");    
 
 while (trouve) {
  trouve = FAUX;
  p = *b;
  
  while (p != NULL) {
   if (appliquerRegle(l,p)) {
    printf("\nUtilise R%d:\n",p->id);
    supprimerRegle(b,p->id);
    trouve = VRAI;

    printf("Faits: ");
    afficherListeFaits(*l);
    printf("\n");
    printf("Regles: ");
    afficherListeRegles2(*b);
    printf("\n");    
   }
   
   p = p->suiv;
  }
 }	
}

/*----------------------------------------------------------------------------*/
/* 15 */
/* Titre: afficherConclusions
   Entrees: une liste de faits "l",
            le tableau "t" qui contient l'intitule de tous les faits.
   Finalite: affiche les faits contenus dans la liste "l" avec leur intitule. 
*/

void afficherConclusions(FAIT * l, char t[50][256]) {
 while (l != NULL) {
  printf("F%d: %s",l->id,t[l->id - 1]);
 	
  l = l->suiv;
 }
}

/*----------------------------------------------------------------------------*/
/* 16 */
/* Titre: viderListeFaits
   Entrees: un pointeur "l" sur une liste de faits.
   Finalite: vider la liste "l" en liberant la memoire occupee par les faits
             de cette liste.
   Strategie: retirer le fait en tete de la liste et liberer la memoire
              qu'il occupe. Cette operation est repetee jusqu'a ce que la
              liste soit vide.
*/

void viderListeFaits(FAIT ** l) {
 FAIT * p;
 
 while (*l != NULL) {
  p = *l;
  *l = (*l)->suiv;
  LIBERER(p);
 }	
}

/*----------------------------------------------------------------------------*/
/* 17 */
/* Titre: viderListeRegles
   Entrees: un pointeur "l" sur une liste de regles.
   Finalite: vider la liste "l" en liberant la memoire occupee par les regles
             de cette liste.
   Strategie: retirer la regle en tete de la liste et liberer la memoire
              qu'il occupe. Cette operation est repetee jusqu'a ce que la
              liste soit vide.
*/

void viderListeRegles(REGLE ** l) {
 REGLE * p;
 
 while (*l != NULL) {
  p = *l;
  viderListeFaits(&(p->hyps));
  viderListeFaits(&(p->ccls));
  *l = (*l)->suiv;
  LIBERER(p);
 }	
}

/*----------------------------------------------------------------------------*/
/* MAIN */

int main(void) {
 char intitules[50][256]; /* Intitules des faits. */
 FILE * f; /* Fichier pour lire la base de faits et la base de regles. */
 FAIT * faits; /* Liste des faits saisis par l'utilisateur. */
 int n; /* Nombre de faits dans la base. */
 REGLE * regles; /* La base de regles. */
 
 /* Lecture des faits. */
 f = fopen("faits.txt","r");
 lireBaseFaits(f,intitules,&n);
 fclose(f);
 printf("BASE DE FAITS:\n");
 afficherBaseFaits(intitules,n);
 printf("\n");
 
 /* Lecture des regles. */
 f = fopen("regles.txt","r");
 lireBaseRegles(f,&regles);
 fclose(f);
 printf("BASE DE REGLES:\n");
 afficherListeRegles(regles);
 printf("\n");
 
 /* Saisie d'une liste de faits. */
 printf("SAISIR LES FAITS:\n");
 saisirListeFaits(&faits);
 printf("\n");
 
 /* Recherche des conclusions. */
 printf("RECHERCHE DES CONCLUSIONS:\n");
 trouverConclusions(&regles,&faits);
 printf("\n");
 
 /* Affichage des conclusions. */
 
 printf("CONCLUSIONS:\n");
 afficherConclusions(faits,intitules);
 
 /* Liberation de la memoire occupee par les listes. */
 viderListeFaits(&faits);
 viderListeRegles(&regles);
 
 return (0);
}

/*----------------------------------------------------------------------------*/
/* FIN */
