/*----------------------------------------------------------------------------*/
/* TP3: LISTES CHAINEES                                                 TP3.H */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* gardien */

#ifndef TP3_H
#define TP3_H

/*----------------------------------------------------------------------------*/
/* HEADERS */

#include "../tp1/commun.h"

/*----------------------------------------------------------------------------*/
/* TYPES */

typedef struct _FAIT_ {
 int             id; /* Identifiant du fait. */
 struct _FAIT_ * suiv; /* Pointeur sur le fait suivant dans la liste. */
}
FAIT;

typedef struct _REGLE_ {
 int              id; /* Identifiant de la regle. */
 FAIT *           hyps; /* Liste des hypotheses. */
 FAIT *           ccls; /* Liste des conclusions. */
 struct _REGLE_ * suiv; /* Pointeur sur la regle suivante dans la liste. */
}
REGLE;

/*----------------------------------------------------------------------------*/
/* PROTOTYPES */

/* 1 */ /* Ajoute un fait en tete d'une liste. */
void ajouterFait(FAIT ** l, FAIT * p);

/* 2 */ /* Ajoute une regle en tete d'une liste. */
void ajouterRegle(REGLE ** l, REGLE * p);

/* 3 */ /* Lit une base de faits dans un fichier et la stocke dans un
           tableau. */
void lireBaseFaits(FILE * f, char b[50][256], int * n);

/* 4 */ /* Affiche une base de faits. */
void afficherBaseFaits(char b[50][256], int n);

/* 5 */ /* Lit une regle dans un fichier. */
BOOLEEN lireRegle(FILE * f, REGLE * r);
	
/* 6 */ /* Lit une base de regles dans un fichier. */
void lireBaseRegles(FILE * f, REGLE ** b);

/* 7 */ /* Affiche une liste de faits. */
void afficherListeFaits(FAIT * l);

/* 8 */ /* Affiche une liste de regles. */
void afficherListeRegles(REGLE * l);

/* 9 */ /* Saisit une liste de faits. */
void saisirListeFaits(FAIT ** f);

/* 10 */ /* Indique si un fait se trouve dans une liste de faits. */
BOOLEEN faitPresent(FAIT * l, int id);

/* 11 */ /* Applique une regle sur une liste de faits. */
BOOLEEN appliquerRegle(FAIT ** l, REGLE * r);

/* 12 */ /* Supprime une regle d'une liste de regles. */
void supprimerRegle(REGLE ** l, int id);

/* 13 */ /* Affiche une liste de regles (seulement les identifiants). */
void afficherListeRegles2(REGLE * l);

/* 14 */ /* Trouve les conclusions deductibles d'une liste de faits en
            s'appuyant sur une base de regles. */
void trouverConclusions(REGLE ** br, FAIT ** lf);

/* 15 */ /* Affiche une liste de faits avec leur intitule. */
void afficherConclusions(FAIT * l, char t[50][256]);

/* 16 */ /* Libere la memoire occupee par les faits d'une liste. */
void viderListeFaits(FAIT ** l);

/* 17 */ /* Libere la memoire occupee par les regles d'une liste. */
void viderListeRegles(REGLE ** l);

/*----------------------------------------------------------------------------*/
/* FIN */

#endif

