//==============================================================================
// T P 3                                                                 Classe
// B a s e F a i t
//==============================================================================

// Cette classe represente une base de faits.

// Package //-------------------------------------------------------------------
package tp3;

// Importation //---------------------------------------------------------------
import entreeSortie.*;

// Classe  B a s e F a i t //---------------------------------------------------
public class BaseFait {
 //--------------------------------------------------------------------Attributs
 protected String noms[]; // Noms des faits de la base.
 protected int    nombre; // Nombre de faits dans la base.
 //-----------------------------------------------------------------Constructeur
 // Finalite: construire une base de faits.
 //
 public BaseFait() {
  noms = null;
  nombre = 0;
 }
 //--------------------------------------------------------------------------Nom
 // Entrees: l'identifiant "id" d'un fait. 
 // Finalite: retourner le nom associe a "id".
 //
 public String nom(int id) { return noms[id-1]; }
 //-------------------------------------------------------------------------Lire
 // Entrees: un fichier "f".
 // Finalite: lire dans "f" une base de faits et les stocker dans le
 //           tableau "noms".
 // Variables inter: un booleen "ok" qui vaut "VRAI" tant qu'il reste un fait
 //                  a lire dans le fichier "f".
 // Strategie: lire une ligne du fichier "f" jusqu'a trouver la chaine 
 //            de caracteres "<fin>".
 //
 public void lire(FichierEntree f) {
  boolean ok = true;
  
  nombre = 0;
  noms = new String[50];
  
  while (ok && nombre < 50) {
   noms[nombre] = f.lireLigne();
   
   if (noms[nombre].equals("<fin>")) ok = false;
   else nombre++;
  }
 }
 //---------------------------------------------------------------------Afficher
 // Finalite: afficher les faits de la base.
 // Variables inter: un entier "i" pour parcourir le tableau.
 //
 void afficher() {
  int i = 0;
 
  while (i < nombre) {
   Ecran.ecrire("F" + (i + 1) + " " + noms[i] + "\n");
   i++;
  }
 }
}

// Fin //-----------------------------------------------------------------------
