//==============================================================================
// T P 3                                                                 Classe
// L i s t e F a i t
//==============================================================================

// Cette classe represente une liste de faits.

// Package //-------------------------------------------------------------------
package tp3;

// Importation //---------------------------------------------------------------
import entreeSortie.*;

// Classe  L i s t e F a i t //-------------------------------------------------
public class ListeFait {
 //--------------------------------------------------------------------Attributs
 protected static String base[]; // 
 protected Fait tete; // Tete de la liste.
 //-----------------------------------------------------------------Constructeur
 // Finalite: construire une liste de faits.
 //
 public void ListeFait() { tete = null; }
 //----------------------------------------------------------------------Ajouter
 // Entrees: un fait "f".
 // Finalite: ajouter le fait "f" en tete de la liste.
 // Variables inter: le fait "f2" qui est l'ancienne tete de la liste.
 //
 public void ajouter(Fait f) {
  Fait f2 = tete;
  
  tete = f;
  f.suiv = f2;
 }
 //-----------------------------------------------------------------------Saisir
 // Finalite: permettre a l'utilisateur de saisir une liste de faits.
 // Variables inter: un entier "i" pour saisir le numero du fait,
 //                  un fait "f".
 // Strategie: demande a l'utilisateur un numero de fait et l'ajoute
 //            dans la liste. Si le numero "0" est entre, alors
 //            la saisie est terminee.
 //
 public void saisir() {
  int i;
  Fait f;
 
  tete = null;
  
  do {
   Ecran.ecrire("Fait ? ");
   i = Clavier.lireEntier();
   
   if (i != 0) {
    f = new Fait();
    f.id = i;
    ajouter(f);
   }
  }
  while (i != 0);
 }  
 //---------------------------------------------------------------------Afficher
 // Finalite: afficher le contenu de la liste.
 // Strategie: parcours la liste en affichant des informations sur chaque
 //            fait visite.
 // Variables inter: le fait "f" a afficher.
 //
 public void afficher() {
  Fait f = tete;
 
  while (f != null) {
   Ecran.ecrire("F" + f.id + " ");
   f = f.suiv;
  }
 }
 //---------------------------------------------------------------------Afficher
 // Entrees: la base de fait "b" qui contient l'intitule de tous les faits.
 // Finalite: afficher les faits contenus dans la liste avec leur intitule. 
 // Variables inter: le fait "f" a afficher.
 //
 public void afficher(BaseFait b) {
  Fait f = tete;
  
  while (f != null) {
   Ecran.ecrire("F" + f.id + ": " + b.nom(f.id) + "\n");
   f = f.suiv;
  }
 }
 //----------------------------------------------------------------------Present
 // Entrees: un entier "id" qui identifie un fait.
 // Finalite: indiquer si le fait "id" est dans la liste.
 // Sortie: "VRAI" si le fait "id" est present dans la liste.
 // Variables inter: un booleen "trouve" qui indique si "id" a ete trouve
 //                  dans la liste,
 //                  un fait "f".
 // Strategie: parcours la liste et compare l'identifiant de chaque fait
 //            visite avec "id".
 //
 public boolean present(int id) {
  Fait f = tete;
  boolean trouve = false;
 
  while (f != null && !trouve) {
   if (f.id == id) trouve = true;
   f = f.suiv;
  }

  return trouve;
 }
 //--------------------------------------------------------------------Appliquer
 // Entrees: une regle "r".
 // Finalite: applique la regle "r" si les faits dans la liste le permettent,
 //           les conclusions de "r" sont alors mises dans la liste.
 // Sortie: "VRAI" si la regle "r" a pu etre appliquee.
 // Variables inter: un booleen "ok" qui indique si la regle peut etre
 //                  appliquee,
 //                  un fait "f" pour parcourir la liste des hypotheses et
 //                  la liste des conclusions,
 //                  un fait "f2" pour l'ajout dans la liste.
 // Strategie: verifie d'abord que tous les faits de l'hypothese sont presents
 //            dans la liste,
 //            si la regle est applicable, les faits de la conclusion sont
 //            ajoutes dans la liste.
 //
 public boolean appliquer(Regle r) {
  boolean ok = true;
  Fait f = r.hyps.tete;
  Fait f2;
 
  // Verifie que les hypotheses sont dans la liste de faits.
  while (f != null && ok) {
   if (!present(f.id)) ok = false;
   f=f.suiv;
  }

  if (ok) {
   // Ajoute les conclusions dans la liste des faits.
   f = r.ccls.tete;
   ok = false;
 
   while (f != null) {
    if (!present(f.id)) {
     f2 = new Fait();
     f2.id = f.id;
     ajouter(f2);
     ok = true;
    }
   
    f = f.suiv;
   }
  }
 
  return ok;
 }
}

// Fin //-----------------------------------------------------------------------
