//==============================================================================
// T P 3                                                                 Classe
// L i s t e R e g l e
//==============================================================================

// Cette classe represente une liste de regles.

// Package //-------------------------------------------------------------------
package tp3;

// Importation //---------------------------------------------------------------
import entreeSortie.*;

// Classe  L i s t e R e g l e //-----------------------------------------------
public class ListeRegle {
 //--------------------------------------------------------------------Attributs
 protected Regle tete; // Tete de la liste.
 //-----------------------------------------------------------------Constructeur
 // Finalite: Construire une liste de regles.
 //
 public void ListeRegle() {
  tete = null;
 }
 //----------------------------------------------------------------------Ajouter
 // Entrees: une regle "r".
 // Finalite: ajouter la regle "r" en tete de la liste.
 // Variables inter: la regle "r2" qui est l'ancienne tete de la liste.
 //
 public void ajouter(Regle r) {
  Regle r2 = tete;
 
  tete = r;
  r.suiv = r2;
 }
 //-------------------------------------------------------------------------Lire
 // Entrees: un fichier "f".
 // Finalite: lire dans "f" des regles et les stocker dans la liste.
 // Variables inter: un booleen "ok" qui vaut "VRAI" tant qu'il reste une regle
 //                  a lire dans le fichier "f",
 //                  une regle "r",
 //                  un entier "i" pour compter les regles.
 //
 public void lire(FichierEntree f) {
  int i = 1;
  boolean ok = true;
  Regle r;
 
  tete = null;
 
  while (ok) {
   r = new Regle();
   r.id = i;
   ok = r.lire(f);
  
   if (ok) ajouter(r);
   i++;
  } 
 }
 //---------------------------------------------------------------------Afficher
 // Finalite: afficher le contenu de la liste.
 // Strategie: parcours la liste en affichant des informations sur chaque
 //            regle visitee.
 // Variables inter: la regle "r" a afficher.
 //
 public void afficher() {
  Regle r = tete;
  
  while (r != null) {
   Ecran.ecrire("R" + r.id + ": ");
   r.hyps.afficher();
   Ecran.ecrire("=> ");
   r.ccls.afficher();
   Ecran.ecrire("\n"); 
   r=r.suiv;
  }
 }
 //--------------------------------------------------------------------Afficher2
 // Finalite: afficher l'identifiant des regles de la liste.
 // Strategie: parcours la liste en affichant l'identifiant de chaque
 //            regle visitee.
 // Variables inter: la regle "r" a afficher.
 //
 public void afficher2() {
  Regle r = tete;
  
  while (r != null) {
   Ecran.ecrire("R" + r.id + " ");
   r = r.suiv;
  }
 }
 //--------------------------------------------------------------------Supprimer
 // Entrees: un entier "id" qui identifie une regle.
 // Finalite: supprimer la regle "id" de la liste.
 // Variables inter: deux regles "r1" et "r2" pour parcourir la liste.
 // Strategie: parcours la liste pour trouver la regle d'identifiant "id",
 //            modifie les liens pour enlever la regle trouvee.
 //
 public void supprimer(int id) {
  Regle r1 = null;
  Regle r2 = tete;

  while (r2 != null && r2.id != id) {
   r1 = r2;
   r2 = r2.suiv;
  }

  if (r2 != null) {
   if (r1 == null) tete = r2.suiv;
   else r1.suiv = r2.suiv;
  }
 }
 //---------------------------------------------------------------------Conclure
 // Entrees: une liste de faits "f".
 // Finalite: trouver toutes les conclusions qu'il est possible de deduire a
 //           partir de la liste de faits "f" en appliquant les regles de la
 //           liste. 
 // Variables inter: un booleen "trouve" qui indique si de nouveaux faits ont
 //                  ete trouves,
 //                  une regle "r".
 // Strategie: tant que des nouveaux faits sont trouves, on parcours la liste
 //            des regles pour en trouver une qui soit applicable. Une fois
 //            appliquee, la regle est retiree de la base des regles.
 //
 public void conclure(ListeFait f) {
  boolean trouve = true;
  Regle r;

  Ecran.ecrire("Faits: ");
  f.afficher();
  Ecran.ecrire("\n");
  Ecran.ecrire("Regles: ");
  afficher2();
  Ecran.ecrire("\n");    
 
  while (trouve) {
   trouve = false;
   r = tete;
  
   while (r != null) {
    if (f.appliquer(r)) {
     Ecran.ecrire("\nUtilise R" + r.id + ":\n");
     supprimer(r.id);
     trouve = true;

     Ecran.ecrire("Faits: ");
     f.afficher();
     Ecran.ecrire("\n");
     Ecran.ecrire("Regles: ");
     afficher2();
     Ecran.ecrire("\n");    
    }
   
    r = r.suiv;
   }
  }	
 }
}

// Fin //-----------------------------------------------------------------------
