//==============================================================================
// T P 3                                                                 Classe
// R e g l e
//==============================================================================

// Cette classe represente une regle.

// Package //-------------------------------------------------------------------
package tp3;

// Importation //---------------------------------------------------------------
import entreeSortie.*;

// Classe  R e g l e //---------------------------------------------------------
public class Regle {
 //--------------------------------------------------------------------Attributs
 public int       id; // Identifiant de la regle.
 public ListeFait hyps; // Liste des hypotheses.
 public ListeFait ccls; // Liste des conclusions.
 public Regle     suiv; // Regle suivante dans la liste.
 //-----------------------------------------------------------------Constructeur
 // Finalite: construire une regle.
 //
 public Regle() {
  id = 0;
  hyps = null;
  ccls = null;
  suiv = null;
 }
 //-------------------------------------------------------------------------Lire
 // Entrees: un fichier "f".
 // Finalite: lire dans le fichier "f" les donnees sur une regle et les stocke
 //           dans la regle.
 // Sortie: renvoie "FAUX" s'il n'y a plus de regle a lire dans le fichier.
 // Variables inter: un entier "i" pour compter les hypotheses et 
 //                  les conclusions,
 //                  un fait "a",
 //                  une chaine de caracteres "c" pour la lecture dans le
 //                  fichier.                    
 // Strategie: lit les hypotheses et les ajoute dans la liste des hypotheses,
 //            lit les conclusions et les ajoute dans la liste des conclusions,
 //            la syntaxe pour une regle est la suivante:
 //               4 & 3 & 2 => 1 & 8 ;
 //               (les faits F4, F3 et F2 impliquent les faits F1 et F8).
 //
 public boolean lire(FichierEntree f) {
  String c;
  Fait a;
  int i;
 
  hyps = new ListeFait();
  ccls = new ListeFait();
 
  // Lecture des hypotheses.
  do {
   i = f.lireEntier();
   if (i == 0) return false;
   a = new Fait();
   a.id = i;
   hyps.ajouter(a);
   c = f.lireChaine();
  }
  while (!c.equals("=>"));
 
  // Lecture des conclusions.
  do {
   i = f.lireEntier();
   a = new Fait();
   a.id = i;
   ccls.ajouter(a);
   c = f.lireChaine();
  }
  while (!c.equals(";"));
 
  return true;
 }
}

// Fin //-----------------------------------------------------------------------
