/*----------------------------------------------------------------------------*/
/* TP4: PILES                                                           TP4.C */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* HEADERS */

#include "tp4.h"

/*----------------------------------------------------------------------------*/
/* 1 */
/* Titre: empiler
   Entrees: un pointeur "p" sur une pile d'entiers,
            un entier "e".
   Finalite: empiler l'entier "e" au sommet de la pile "p".
   Hypotheses: la pile n'est pas pleine.
*/

void empiler(PILE * p, int e) {
 p->tab[p->n] = e;
 (p->n)++;
}

/*----------------------------------------------------------------------------*/
/* 2 */
/* Titre: depiler
   Entrees: un pointeur "p" sur une pile d'entiers.
   Finalite: depiler l'entier au sommet de la pile "p", l'entier est
             retourne par la fonction.
   Hypotheses: la pile n'est pas vide.
*/

int depiler(PILE * p) {
 (p->n)--;
 return (p->tab[p->n]);
}

/*----------------------------------------------------------------------------*/
/* 3 */
/* Titre: afficherPile
   Entrees: une pile "p".
   Finalite: afficher le contenu de la pile "p".
   Variables inter: un entier "i" pour parcourir le tableau representant
                    la pile "p".
   Strategie: parcours le tableau representant la pile et affiche les entiers
              qu'il contient.
*/

void afficherPile(PILE p) {
 int i = 0;

 while (i < p.n) {
  printf(" %d",p.tab[i]);
  i++;
 }

 printf("\n");
}

/*----------------------------------------------------------------------------*/
/* 4 */
/* Titre: preparerJeu
   Entrees: un tableau "t" de piles,
            un entier "n" indiquant le nombre d'anneaux dans le jeu,
            un entier "p" indiquant un poteau.
   Finalite: preparer le jeu represente par "t" en empilant "n" anneaux
             sur le poteau "p" et en laissant vides les deux autres poteaux.
   Variables inter: un entier "i" pour parcourir le tableau "t".
   Strategie: initialise les trois piles du jeu et ensuite empile les "n"
              premiers entiers dans la pile d'indice "p".
*/

void preparerJeu(PILE * t, int n, int p) {
 int i = 0;

 while (i < 3) {
  t[i].n = 0;
  i++;
 }

 while (n>0) {
  empiler(&t[p],n);
  n--;
 }
}

/*----------------------------------------------------------------------------*/
/* 5 */
/* Titre: afficherJeu
   Entrees: un tableau "t" de piles.
   Finalite: afficher l'etat du jeu represente par "t".
   Variables inter: un entier "i" pour parcourir le tableau "t".
   Strategie: affiche le contenu de chacune des trois piles, ces dernieres
              representant les poteaux du jeu.
*/

void afficherJeu(PILE * t) {
 char c;
 int i = 0;

 while (i < 3) {
  printf("Poteau %d =",i);
  afficherPile(t[i]);
  i++;
 }

 scanf("%c",&c);
}

/*----------------------------------------------------------------------------*/
/* 6 */
/* Titre: deplacerAnneaux
   Entrees: un tableau "t" de piles representant le jeu,
            un entier "n" indiquant le nombre d'anneaux a deplacer,
            un entier "a" indiquant le poteau de depart,
            un entier "b" indiquant le poteau d'arrivee.
   Finalite: dans le jeu represente par "t", deplacer "n" anneaux du poteau
             "a" au poteau "b" en respectant les regles du jeu.
   Variables inter: un entier "c" pour indiquer le poteau intermediaire,
                    un entier "e" pour effectuer le deplacement d'un anneau.
*/

void deplacerAnneaux(PILE * t, int n, int a, int b) {
 int c;
 int e;

 if (n == 1) {
  e = depiler(&t[a]);
  empiler(&t[b],e);
  afficherJeu(t);
 }
 else {
  c = 3 - a - b; /* Un moyen de trouver le numero du poteau intermediaire. */
  deplacerAnneaux(t,n - 1,a,c);
  deplacerAnneaux(t,1,a,b);
  deplacerAnneaux(t,n - 1,c,b);
 }
}

/*----------------------------------------------------------------------------*/
/* MAIN */

int main()
{
 PILE t[3];

 preparerJeu(t,NB_ANNEAUX,0);
 afficherJeu(t);
 deplacerAnneaux(t,NB_ANNEAUX,0,2);

 return 0;
}

/*----------------------------------------------------------------------------*/
/* FIN */
