//==============================================================================
// H a n o i A p p l e t                                                 Classe
// H a n o i
//                                                           Par Bruno Bachelet
//==============================================================================
// Copyright (c) 1999-2016
// Bruno Bachelet - bruno@nawouak.net - http://www.nawouak.net
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the license, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details (http://www.gnu.org).

// Cette classe represente le jeu de la tour de Hanoi.

// Classe  H a n o i //---------------------------------------------------------
public class Hanoi {
 //--------------------------------------------------------------------Attributs
 protected Pile        jeu[]; // Les trois piles qui representent le jeu.
 protected HanoiApplet applet; // Applet ou le jeu est dessine.
 //-----------------------------------------------------------------Constructeur
 // Entrees: un entier "n" indiquant le nombre d'anneaux dans le jeu,
 //          un entier "p" indiquant un poteau.
 // Finalite: construire et preparer le jeu en empilant "n" anneaux sur le
 //           poteau "p" et en laissant vides les deux autres poteaux.
 // Variables inter: un entier "i" pour parcourir le tableau "jeu".
 // Strategie: initialise les trois piles du jeu et ensuite empile les "n"
 //            premiers entiers dans la pile d'indice "p".
 //
 public Hanoi(int n, int p, HanoiApplet applet_) {
  int i = 0;

  jeu = new Pile[3];

  while (i < 3) {
   jeu[i] = new Pile(n);
   jeu[i].n = 0;
   i++;
  }

  while (n>0) {
   jeu[p].empiler(n);
   n--;
  }

  applet = applet_;
 }
 //----------------------------------------------------------------------Simuler
 // Entrees: un entier "n" indiquant le nombre d'anneaux dans le jeu,
 //          un entier "a" indiquant le poteau de depart,
 //          un entier "b" indiquant le poteau d'arrivee.
 // Finalite: simuler le jeu.
 //
 public void simuler(int n, int a, int b) {
  applet.afficherJeu(jeu);
  deplacerAnneaux(n,a,b);
 }
 //--------------------------------------------------------------DeplacerAnneaux
 // Entrees: un entier "n" indiquant le nombre d'anneaux a deplacer,
 //          un entier "a" indiquant le poteau de depart,
 //          un entier "b" indiquant le poteau d'arrivee.
 // Finalite: dans le jeu, deplacer "n" anneaux du poteau
 //           "a" au poteau "b" en respectant les regles du jeu.
 // Variables inter: un entier "c" pour indiquer le poteau intermediaire,
 //                  un entier "e" pour effectuer le deplacement d'un anneau.
 //
 public void deplacerAnneaux(int n, int a, int b) {
  int c;
  int e;

  if (n == 1) {
   e = jeu[a].depiler();
   jeu[b].empiler(e);
   applet.afficherJeu(jeu);
  }
  else {
   c = 3 - a - b; // Un moyen de trouver le numero du poteau intermediaire.
   deplacerAnneaux(n - 1,a,c);
   deplacerAnneaux(1,a,b);
   deplacerAnneaux(n - 1,c,b);
  }
 }
}

// Fin //-----------------------------------------------------------------------
