//==============================================================================
// H a n o i A p p l e t                                                 Applet
// A p p l e t
//                                                           Par Bruno Bachelet
//==============================================================================
// Copyright (c) 1999-2016
// Bruno Bachelet - bruno@nawouak.net - http://www.nawouak.net
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the license, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details (http://www.gnu.org).

// Cette applet anime le jeu de la tour de Hanoi.

// Importation //---------------------------------------------------------------
import java.util.*;
import java.applet.*;
import java.awt.*;

// Classe  H a n o i A p p l e t //---------------------------------------------
public class HanoiApplet extends Applet implements Runnable {
 //-------------------------------------------------------------------Constantes
 protected int NB_ANNEAUX = 7; // Nombre d'anneaux.
 //-------------------------------------------------------------------Attributes
 protected Font        fonte;         // Fonte utilisee pour ecrire des
                                      // informations.
 protected FontMetrics metriqueFonte; // Metrique de la fonte.

 protected int largeur; // Largeur de l'applet.
 protected int hauteur; // Hauteur de l'applet.

 protected Color couleurFond;   // Couleur du fond de l'applet.
 protected Color couleurDessin; // Couleur des dessins.

 protected Image imageOff;       // Image pour eviter le scintillement.
 protected Image imageCopyright; // Image du copyright.

 protected Thread gardienTemps = null; // Thread qui maintient l'applet en vie.

 protected Hanoi hanoi; // Tour de Hanoi.
 protected int   clic;  // Indique si un clic de souris est survenu.
 //-------------------------------------------------------------------------Init
 // Initialise l'applet.
 //
 public void init() {
  Graphics c;

  // Parametres de l'applet.
  largeur = Integer.parseInt(getParameter("largeur"));
  hauteur = Integer.parseInt(getParameter("hauteur"));

  // Preparation du contexte graphique.
  fonte = new Font("Arial",Font.PLAIN,10);
  metriqueFonte = getFontMetrics(fonte);
  couleurFond = Color.white;
  couleurDessin = Color.black;
  setBackground(couleurFond);
  setForeground(couleurDessin);

  // Creation de l'image du copyright.
  imageCopyright = createImage(largeur,hauteur);
  c = imageCopyright.getGraphics();
  c.clipRect(0,0,largeur,hauteur);
  dessinerCopyright(c);

  // Creation de l'image off.
  imageOff = createImage(largeur,hauteur);

  // Initialisation des attributs.
  hanoi = null;
  clic = 0;
 }
 //------------------------------------------------------------------------Start
 // Demarre l'applet.
 //
 public void start() {
  if(gardienTemps == null) {
   gardienTemps = new Thread(this);
   gardienTemps.start();
  }
 }
 //--------------------------------------------------------------------------Run
 // Execute l'applet.
 //
 public void run() {
  afficherJeu(null);

  while(true) {
   if (hanoi != null) {
    afficherJeu(null);
    hanoi.simuler(NB_ANNEAUX,0,2);
    hanoi = null;
   }

   if (clic > 0) repaint();

   try { gardienTemps.sleep(250); }
   catch(Exception agException) { return; }
  }
 }
 //-------------------------------------------------------------------------Stop
 // Arrete l'applet.
 //
 public void stop() {
  if (gardienTemps != null) {
   gardienTemps.stop();
   gardienTemps = null;
  }
 }
 //-----------------------------------------------------------------------Update
 // Rafraichit l'applet.
 //
 public void update(Graphics contexte) { paint(contexte); }
 //------------------------------------------------------------------------Paint
 // Affiche l'applet.
 //
 public void paint(Graphics contexte) {
  if (clic > 0) {
   contexte.drawImage(imageCopyright,0,0,this);
   clic--;
   if (clic == 0 && hanoi == null) hanoi = new Hanoi(NB_ANNEAUX,0,this);
  }
  else contexte.drawImage(imageOff,0,0,this);
 }
 //----------------------------------------------------------------GetAppletInfo
 // Retourne des informations sur l'applet.
 //
 public String getAppletInfo()
 { return "Copyright (c) 1999-2016 - Bruno Bachelet - http://www.nawouak.net"; }
 //----------------------------------------------------------------------KeyDown
 // Quand une touche est pressee...
 //
 public boolean keyDown(Event evenement, int touche) { return true; }
 //--------------------------------------------------------------------MouseDown
 // Quand un bouton de la souris est enfonce...
 public boolean mouseDown(Event evenement,int x,int y) {
  clic = 4;
  return (true);
 }
 //------------------------------------------------------------------AfficherJeu
 // Finalite: afficher la tour de Hanoi.
 //
 public void afficherJeu(Pile jeu[]) {
  Graphics c = imageOff.getGraphics();
  int i = -25;
  String chaine;

  // Effacement zone de dessin.
  c.setColor(couleurFond);
  c.fillRect(0,0,largeur,hauteur);
  c.setColor(couleurDessin);

  // Sol.
  c.drawLine(0,hauteur - 25,largeur,hauteur - 25);

  while (i < largeur) {
   c.drawLine(i,hauteur,i + 25,hauteur - 25);
   i += 5;
  }

  // Poteaux.
  c.drawRect(largeur / 4 - 5,20,10,hauteur - 45);
  c.drawRect(largeur / 2 - 5,20,10,hauteur - 45);
  c.drawRect(largeur * 3 / 4 - 5,20,10,hauteur - 45);

  // Piles.
  if (jeu != null) {
   afficherPile(c,jeu[0],0);
   afficherPile(c,jeu[1],1);
   afficherPile(c,jeu[2],2);
  }

  // Affichage de l'image et pause.
  try {
   repaint();
   gardienTemps.sleep(250);
   repaint();
   gardienTemps.sleep(250);
  }
  catch(Exception agException) { return; }
 }
 //-----------------------------------------------------------------AfficherPile
 // Finalite: afficher une pile d'anneaux.
 //
 protected void afficherPile(Graphics contexte, Pile pile, int poteau) {
  Color c1 = new Color(192,192,192);
  Color c2 = new Color(128,128,128);
  Pile p = new Pile(NB_ANNEAUX);
  int x = largeur * (poteau + 1) / 4;
  int y = hauteur - 25;
  int i;

  // Depilement.
  while (!pile.vide()) {
   i = pile.depiler();
   p.empiler(i);
  }

  // Rempilement et affichage.
  while (!p.vide()) {
   i = p.depiler();
   pile.empiler(i);
   y -= 8;

   contexte.setColor(c1);
   contexte.fillRect(x - 13 - i * 8,y,i * 8,8);
   contexte.fillRect(x + 13,y,i * 8,8);

   contexte.setColor(c2);
   contexte.fillRect(x - 13,y,8,8);
   contexte.fillRect(x + 5,y,8,8);

   contexte.setColor(couleurDessin);
   contexte.drawRect(x - 13,y,8,8);
   contexte.drawRect(x - 13 - i * 8,y,i * 8,8);
   contexte.drawRect(x + 5,y,8,8);
   contexte.drawRect(x + 13,y,i * 8,8);
  }
 }
 //------------------------------------------------------------DessinerCopyright
 // Finalite: dessiner l'image du copyright.
 //
 protected void dessinerCopyright(Graphics contexte) {
  String c;
  int x;
  int y;

  // Effacement zone de dessin.
  contexte.setColor(couleurFond);
  contexte.fillRect(0,0,largeur,hauteur);
  contexte.setFont(fonte);
  contexte.setColor(couleurDessin);

  x = (int)(largeur * 0.5);
  y = (int)(hauteur * 0.5 - metriqueFonte.getHeight() / 2);
  c = "Copyright (c) 1999-2016";

  contexte.drawString(c,x - metriqueFonte.stringWidth(c) / 2,
                      y + metriqueFonte.getHeight() / 4);

  y = (int)(hauteur * 0.5 + metriqueFonte.getHeight() / 2);
  c = "http://www.nawouak.net";

  contexte.drawString(c,x - metriqueFonte.stringWidth(c) / 2,
                      y + metriqueFonte.getHeight() / 4);
 }
}

// Fin //-----------------------------------------------------------------------
