//==============================================================================
// H a n o i A p p l e t                                                 Classe
// P i l e
//                                                           Par Bruno Bachelet
//==============================================================================
// Copyright (c) 1999-2016
// Bruno Bachelet - bruno@nawouak.net - http://www.nawouak.net
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the license, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details (http://www.gnu.org).

// Cette classe represente une pile.

// Classe  P i l e //-----------------------------------------------------------
public class Pile {
 //--------------------------------------------------------------------Attributs
 protected int tab[]; // Permet de stocker les elements.
 protected int n; // Indice du sommet de la pile.
 //-----------------------------------------------------------------Constructeur
 // Entrees: un entier "t".
 // Finalite: construire et initialiser une pile de taille "t".
 //
 public Pile(int t) {
  tab = new int[t];
  n = 0;
 }
 //-------------------------------------------------------------------------Vide
 // Finalite: indiquer si la pile est vide.
 // Sortie: renvoie "VRAI" si la pile est vide.
 //
 public boolean vide() { return (n == 0); }
 //----------------------------------------------------------------------Empiler
 // Entrees: un entier "e".
 // Finalite: empiler l'entier "e" au sommet de la pile.
 // Hypotheses: la pile n'est pas pleine.
 //
 public void empiler(int e) {
  tab[n] = e;
  n++;
 }
 //----------------------------------------------------------------------Depiler
 // Finalite: depiler l'entier au sommet de la pile, l'entier est retourne
 //           par la fonction.
 // Hypotheses: la pile n'est pas vide.
 //
 public int depiler() {
  n--;
  return (tab[n]);
 }
}

// Fin //-----------------------------------------------------------------------
