//==============================================================================
// T P 4                                                                 Classe
// H a n o i
//==============================================================================

// Cette classe represente le jeu de la tour de Hanoi.

// Package //-------------------------------------------------------------------
package tp4;

// Importation //---------------------------------------------------------------
import entreeSortie.*;

// Classe  H a n o i //---------------------------------------------------------
public class Hanoi {
 //--------------------------------------------------------------------Attributs
 protected Pile jeu[]; // Les trois piles qui representent le jeu.
 //-----------------------------------------------------------------Constructeur
 // Entrees: un entier "n" indiquant le nombre d'anneaux dans le jeu,
 //          un entier "p" indiquant un poteau.
 // Finalite: construire et preparer le jeu en empilant "n" anneaux sur le
 //           poteau "p" et en laissant vides les deux autres poteaux.
 // Variables inter: un entier "i" pour parcourir le tableau "jeu".
 // Strategie: initialise les trois piles du jeu et ensuite empile les "n"
 //            premiers entiers dans la pile d'indice "p".
 //
 public Hanoi(int n, int p) {
  int i = 0;
  
  jeu = new Pile[3];

  while (i < 3) {
   jeu[i] = new Pile(n);
   jeu[i].n = 0;
   i++;
  }

  while (n>0) {
   jeu[p].empiler(n);
   n--;
  }
 }
 //---------------------------------------------------------------------Afficher
 // Finalite: afficher l'etat du jeu.
 // Variables inter: un entier "i" pour parcourir le tableau "jeu".
 // Strategie: affiche le contenu de chacune des trois piles, ces dernieres
 //            representant les poteaux du jeu.
 //
 public void afficher() {
  String c;
  int i = 0;

  while (i < 3) {
   Ecran.ecrire("Poteau "+ i + " =");
   jeu[i].afficher();
   i++;
  }

  c = Clavier.lireChaine();
 }
 //--------------------------------------------------------------DeplacerAnneaux
 // Entrees: un entier "n" indiquant le nombre d'anneaux a deplacer,
 //          un entier "a" indiquant le poteau de depart,
 //          un entier "b" indiquant le poteau d'arrivee.
 // Finalite: dans le jeu, deplacer "n" anneaux du poteau
 //           "a" au poteau "b" en respectant les regles du jeu.
 // Variables inter: un entier "c" pour indiquer le poteau intermediaire,
 //                  un entier "e" pour effectuer le deplacement d'un anneau.
 //
 public void deplacerAnneaux(int n, int a, int b) {
  int c;
  int e;

  if (n == 1) {
   e = jeu[a].depiler();
   jeu[b].empiler(e);
   afficher();
  }
  else {
   c = 3 - a - b; // Un moyen de trouver le numero du poteau intermediaire.
   deplacerAnneaux(n - 1,a,c);
   deplacerAnneaux(1,a,b);
   deplacerAnneaux(n - 1,c,b);
  }
 }
}

// Fin //-----------------------------------------------------------------------
