//==============================================================================
// T P 4                                                                 Classe
// P i l e
//==============================================================================

// Cette classe represente une pile.

// Package //-------------------------------------------------------------------
package tp4;

// Importation //---------------------------------------------------------------
import entreeSortie.*;

// Classe  P i l e //-----------------------------------------------------------
public class Pile {
 //--------------------------------------------------------------------Attributs
 protected int tab[]; // Permet de stocker les elements.
 protected int n; // Indice du sommet de la pile.
 //-----------------------------------------------------------------Constructeur
 // Entrees: un entier "t".
 // Finalite: construire et initialiser une pile de taille "t".
 //
 public Pile(int t) {
  tab = new int[t];
  n = 0;
 }
 //-------------------------------------------------------------------------Vide
 // Finalite: indiquer si la pile est vide.
 // Sortie: renvoie "VRAI" si la pile est vide.
 // 
 public boolean vide() { return (n == 0); }
 //----------------------------------------------------------------------Empiler
 // Entrees: un entier "e".
 // Finalite: empiler l'entier "e" au sommet de la pile.
 // Hypotheses: la pile n'est pas pleine.
 //
 public void empiler(int e) {
  tab[n] = e;
  n++;
 }
 //----------------------------------------------------------------------Depiler
 // Finalite: depiler l'entier au sommet de la pile, l'entier est retourne
 //           par la fonction.
 // Hypotheses: la pile n'est pas vide.
 //
 public int depiler() {
  n--;
  return (tab[n]);
 }
 //---------------------------------------------------------------------Afficher
 // Finalite: afficher le contenu de la pile.
 // Variables inter: un entier "i" pour parcourir le tableau representant
 //                  la pile.
 // Strategie: parcours le tableau representant la pile et affiche les entiers
 //            qu'il contient.
 //
 public void afficher() {
  int i = 0;

  while (i < n) {
   Ecran.ecrire(" " + tab[i]);
   i++;
  }

  Ecran.ecrire("\n");
 }
}

// Fin //-----------------------------------------------------------------------
