/*----------------------------------------------------------------------------*/
/* TP5: FILES D'ATTENTE                                                 TP5.C */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* HEADERS */

#include "tp5.h"

/*----------------------------------------------------------------------------*/
/* 1 */
/* Titre: initialiserTas
   Entrees: un pointeur "t" sur un tas de cartes.
   Finalite: initialiser les champs de la structure "t" pour que le tas soit
             vide.
   Strategie: cf. "initialiserFile" dans le cours.
*/

void initialiserTas(TAS * t) {
 t->tete = NULL;
 t->fin = NULL;
}

/*----------------------------------------------------------------------------*/
/* 2 */
/* Titre: mettreCarte
   Entrees: un pointeur "t" sur un tas de cartes,
            une carte "c".
   Finalite: mettre la carte "c" sous le tas "t".
   Variables inter: "p" un pointeur sur le nouveau maillon.
   Strategie: ajouter "c" a la fin de la liste "t".
*/

void mettreCarte(TAS * t, CARTE c) {
 MAILLON * p = ALLOUER(MAILLON,1);
 
 if (p == NULL) {
  printf("Pas assez de memoire.\n");
  exit(1);
 }
 
 p->carte = c;
 p->suiv = NULL;
 
 if (t->fin == NULL) t->tete = p;
 else t->fin->suiv = p;
 
 t->fin = p;
}

/*----------------------------------------------------------------------------*/
/* 3 */
/* Titre: retirerCarte
   Entrees: un pointeur "t" sur un tas de cartes,
            un pointeur "c" sur une carte.
   Finalite: retirer la carte au dessus du tas "t" et stocker sa valeur a
             l'adresse "c".
   Variables inter: "p" un pointeur sur le maillon a detruire.
   Strategie: retirer la tete de la liste "t".
*/

void retirerCarte(TAS * t, CARTE * c) {
 MAILLON * p = t->tete;

 *c = p->carte;
 t->tete = p->suiv;
 if (t->tete == NULL) t->fin = NULL;
 LIBERER(p);
}

/*----------------------------------------------------------------------------*/
/* 4 */
/* Titre: afficherTas
   Entrees: un tas de cartes "t".
   Finalite: afficher les cartes contenues dans le tas "t".
   Variables inter: "p" un pointeur sur un maillon pour parcourir la liste "t".
                    "symbolesFamille" un tableau qui contient les symboles
                    "coeur", "carreau", "trefle" et "pique",
                    "symbolesPuissance" un tableau qui contient les caracteres
                    pour la puissance des cartes.
   Strategie: parcours la liste "t" et a chaque carte rencontree, on 
              affiche sa valeur en utilisant les tableaux "symbolesFamille"
              et "symbolesPuissance". 
*/

void afficherTas(TAS t) {
 static const char symbolesFamille[] = { '\3','\4','\5','\6' };
 static const char symbolesPuissance[] = { '7','8','9','0','V','D','R','A' };
 
 /* Le mot "static" signifie que ces variables sont globales mais qu'elles
    sont visibles uniquement par la fonction ou elles sont declarees. Cela
    signifie qu'elles sont initialisees une seule fois au debut du
    programme, qu'elles sont detruites uniquement a la fin du programme
    et non pas a la fin de la fonction. Cependant, elles sont utilisees
    comme n'importe quelle autre variable locale. */

 MAILLON * p = t.tete;
 
 printf("[ ");
 
 while (p != NULL) {
  printf("%c%c ",symbolesFamille[p->carte.famille],
         symbolesPuissance[p->carte.puissance]);
  p = p->suiv;
 }

 printf("]\n");
}

/*----------------------------------------------------------------------------*/
/* 5 */
/* Titre: creerJeu
   Entrees: un tableau "j" de 32 cartes.
   Finalite: placer dans le tableau les valeurs des cartes d'un jeu de 32
             cartes classique.
   Variables inter: "c" un pointeur sur une carte,
                    "f" une famille de cartes,
                    "p" une puissance de carte.
   Strategie: enumerer les 32 (4 familles x 8 puissances) cartes du jeu et les
              placer dans le tableau "j".
*/

void creerJeu(CARTE j[32]) {
 CARTE *   c;
 FAMILLE   f;
 PUISSANCE p;

 f = COEUR;
 c = j;

 while (f <= PIQUE) {
  p = SEPT;

  while (p <= AS) {
   c->famille = f;
   c->puissance = p;
   c++;
   p = (PUISSANCE)((int)p + 1);
  }

  f = (FAMILLE)((int)f + 1);
 }
}

/*----------------------------------------------------------------------------*/
/* 6 */
/* Titre: melangerJeu
   Entrees: un tableau "j" de 32 cartes.
   Finalite: melanger les 32 cartes du tableau "j".
   Variables inter: "c" une carte,
                    "i1" et "i2" des indices de tableau.
   Strategie: pour chacune des 32 cartes, choisir aleatoirement une autre
              carte du jeu et les permuter.
*/

void melangerJeu(CARTE j[32]) {
 CARTE c;
 int i1 = 0;
 int i2;

 INITIALISER_ALEATOIRE; 
 
 while (i1 < 32) {
  i2 = NOMBRE_ALEATOIRE(32);
  c = j[i1];
  j[i1] = j[i2];
  j[i2] = c;
  i1++;
 }
}

/*----------------------------------------------------------------------------*/
/* 7 */
/* Titre: distribuerCartes
   Entrees: un tableau "j" de 32 cartes,
            deux tas de cartes "t1" et "t2".
   Finalite: repartir les 32 cartes du tableau "j" equitablement entre les tas
             "t1" et "t2".
   Variables inter: "i" un indice de tableau.
   Strategie: mettre une carte sur deux du tableau "j" dans le tas "t1" et les
              autres dans le tas "t2".
*/

void distribuerCartes(CARTE j[32], TAS * t1, TAS * t2) {
 int i = 0;
 
 initialiserTas(t1);
 initialiserTas(t2);
 
 while (i < 16) {
  mettreCarte(t1,j[2 * i]);
  mettreCarte(t2,j[2 * i + 1]);
  i++;
 }  
}

/*----------------------------------------------------------------------------*/
/* 8 */
/* Titre: deplacerCarte
   Entrees: deux tas "t1" et "t2".
   Finalite: prendre une carte au sommet du tas "t2" et la placer sous le tas
             "t1".
   Variables inter: "c" une carte.
*/

void deplacerCarte(TAS * t1, TAS * t2) {
 CARTE c;

 if (t2->tete != NULL) {
  retirerCarte(t2,&c);
  mettreCarte(t1,c);
 }
}

/*----------------------------------------------------------------------------*/
/* 9 */
/* Titre: deplacerTas
   Entrees: deux tas "t1" et "t2".
   Finalite: placer le tas "t2" sous le tas "t1".
   Variables inter: "c" une carte.
   Strategie: tant que le tas "t2" n'est pas vide, deplace la carte au sommet
              de "t2" sous le tas "t1".
*/

void deplacerTas(TAS * t1, TAS * t2)
{ while (t2->tete != NULL) deplacerCarte(t1,t2); }

/*----------------------------------------------------------------------------*/
/* 10 */
/* Titre: afficherTasS
   Entrees: trois tas "t1", "t2" et "ta".
   Finalite: afficher le contenu des trois tas du jeu de la bataille (le tas
             du joueur 1, celui du joueur 2 et le tas d'attente).
*/

void afficherTasS(TAS t1,TAS t2,TAS ta) {
 #ifdef PAUSE
  char c;
 #endif

 printf("Tas 1 = ");
 afficherTas(t1);
 printf("\nTas 2 = ");
 afficherTas(t2);
 printf("\nAttente = ");
 afficherTas(ta);
 
 #ifdef PAUSE
  scanf("%c",&c);
 #else
  printf("\n");
 #endif
}

/*----------------------------------------------------------------------------*/
/* 11 */
/* Titre: simulerBataille
   Entrees: deux tas "t1" et "t2".
   Finalite: simuler le deroulement d'une partie du jeu de la bataille d'apres
             les regles enoncees.
   Hypotheses: "t1" et "t2" contiennent chacun 16 cartes.
   Variables inter: "c1" et "c2" les deux cartes en bataille a chaque tour,
                    "ta" le tas utilise pour placer les cartes en attente lors
                    d'une egalite.
   Strategie: cf. les regles.
*/

void simulerBataille(TAS * t1,TAS * t2) {
 CARTE c1;
 CARTE c2;
 TAS ta;

 initialiserTas(&ta);
 afficherTasS(*t1,*t2,ta);

 while (t1->tete != NULL && t2->tete != NULL) {
  retirerCarte(t1,&c1);
  retirerCarte(t2,&c2);

  if (c1.puissance > c2.puissance) {
   printf("Joueur 1 gagne !\n\n");
   deplacerTas(t1,&ta);
   mettreCarte(t1,c1);
   mettreCarte(t1,c2);
  }
  else if (c1.puissance < c2.puissance) {
   printf("Joueur 2 gagne !\n\n");
   deplacerTas(t2,&ta);
   mettreCarte(t2,c2);
   mettreCarte(t2,c1);
  }
  else {
   printf("Egalite !\n\n");
   mettreCarte(&ta,c1);
   mettreCarte(&ta,c2);
   deplacerCarte(&ta,t1);
   deplacerCarte(&ta,t2);
  }

  afficherTasS(*t1,*t2,ta);
 }
}

/*----------------------------------------------------------------------------*/
/* MAIN */

int main(void) {
 CARTE j[32];
 TAS t1;
 TAS t2;
 
 creerJeu(j);
 melangerJeu(j);
 distribuerCartes(j,&t1,&t2);
 simulerBataille(&t1,&t2);

 if (t1.tete == NULL) {
  printf("Joueur 2 a gagne !\n");
  while (t2.tete != NULL) retirerCarte(&t2,j);
 }
 else {
  printf("Joueur 1 a gagne !\n");
  while (t1.tete != NULL) retirerCarte(&t1,j);
 }

 return 0;
}

/*----------------------------------------------------------------------------*/
/* FIN */
