/*----------------------------------------------------------------------------*/
/* TP5: FILES D'ATTENTE                                                 TP5.H */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* gardien */

#ifndef TP5_H
#define TP5_H

/*----------------------------------------------------------------------------*/
/* HEADERS */

#include "../tp1/commun.h"
#include <time.h> /* Generation de nombres aleatoires. */

/*----------------------------------------------------------------------------*/
/* MACROS */

#define INITIALISER_ALEATOIRE { srand((unsigned)time(NULL)); }
/* Initialise le generateur de nombres aleatoires. */

#define NOMBRE_ALEATOIRE(n) (rand()%(n))
/* Retourne un nombre aleatoire entre 0 et n-1. */

#define PAUSE
/* Cette macro doit etre definie si on veut faire une pause a chaque
   echange de carte au cours du jeu. */

/*----------------------------------------------------------------------------*/
/* TYPES */

typedef enum { COEUR,CARREAU,TREFLE,PIQUE }           FAMILLE;
typedef enum { SEPT,HUIT,NEUF,DIX,VALET,DAME,ROI,AS } PUISSANCE;

typedef struct {
 FAMILLE   famille; /* Famille de la carte. */
 PUISSANCE puissance; /* Puissance de la carte. */
} CARTE;

typedef struct _MAILLON_ {
 CARTE              carte;
 struct _MAILLON_ * suiv;
} MAILLON; /* Maillon de la file d'attente. */

typedef struct {
 MAILLON * tete;
 MAILLON * fin;
} TAS; /* File d'attente qui represente un tas de cartes. */

/*----------------------------------------------------------------------------*/
/* PROTOTYPES */

/* 1 */ /* Initialise un tas. */
void initialiserTas(TAS * t);

/* 2 */ /* Met une carte sous un tas. */
void mettreCarte(TAS * t, CARTE c);

/* 3 */ /* Retire la carte au sommet d'un tas. */
void retirerCarte(TAS * t, CARTE * c);

/* 4 */ /* Affiche le contenu d'un tas. */
void afficherTas(TAS t);

/* 5 */ /* Cree un jeu de 32 cartes. */
void creerJeu(CARTE j[32]);

/* 6 */ /* Melange un jeu de cartes. */
void melangerJeu(CARTE j[32]);

/* 7 */ /* Distribue un jeu de 32 cartes en deux tas de 16 cartes. */
void distribuerCartes(CARTE j[32], TAS * t1, TAS * t2);

/* 8 */ /* Deplace une carte du sommet d'un tas sous un autre tas. */
void deplacerCarte(TAS * t1, TAS * t2);

/* 9 */ /* Place un tas sous un autre. */
void deplacerTas(TAS * t1, TAS * t2);

/* 10 */ /* Affiche les trois tas qui consituent le jeu. */
void afficherTasS(TAS t1,TAS t2,TAS ta);

/* 11 */ /* Simule le deroulement d'une partie du jeu de la bataille. */
void simulerBataille(TAS * t1,TAS * t2);

/*----------------------------------------------------------------------------*/
/* FIN */

#endif
