//==============================================================================
// T P 5                                                                 Classe
// B a t a i l l e
//==============================================================================

// Cette classe represente le jeu de la bataille.

// Package //-------------------------------------------------------------------
package tp5;

// Importation //---------------------------------------------------------------
import java.util.*;
import entreeSortie.*;

// Classe  B a t a i l l e //---------------------------------------------------
public class Bataille {
 //---------------------------------------------------------------------CreerJeu
 // Entrees: un tableau "j" de 32 cartes.
 // Finalite: placer dans le tableau les valeurs des cartes d'un jeu de 32
 //           cartes classique.
 // Variables inter: "f" une famille de cartes,
 //                  "i" un entier pour parcourir le tableau "j",
 //                  "p" une puissance de carte.
 // Strategie: enumerer les 32 (4 familles x 8 puissances) cartes du jeu et
 //            les placer dans le tableau "j".
 //
 protected static void creerJeu(Carte j[]) {
  int f = Carte.COEUR;
  int i = 0;
  int p;

  while (f <= Carte.PIQUE) {
   p = Carte.SEPT;

   while (p <= Carte.AS) {
    j[i] = new Carte(f,p);
    i++;
    p++;
   }

   f++;
  }
 }
 //------------------------------------------------------------------MelangerJeu
 // Entrees: un tableau "j" de 32 cartes.
 // Finalite: melanger les 32 cartes du tableau "j".
 // Variables inter: "c" une carte,
 //                  "r" un generateur de nombres aleatoires,
 //                  "i1" et "i2" des indices de tableau.
 // Strategie: pour chacune des 32 cartes, choisir aleatoirement une autre
 //            carte du jeu et les permuter.
 //
 protected static void melangerJeu(Carte j[]) {
  Carte c;
  int i1 = 0;
  int i2;
  Random r = new Random();
 
  while (i1 < 32) {
   i2 = (int)(r.nextDouble()*32);
   c = j[i1];
   j[i1] = j[i2];
   j[i2] = c;
   i1++;
  }
 }
 //-------------------------------------------------------------DistribuerCartes
 // Entrees: un tableau "j" de 32 cartes,
 //          deux tas de cartes "t1" et "t2".
 // Finalite: repartir les 32 cartes du tableau "j" equitablement entre les
 //           tas "t1" et "t2".
 // Variables inter: "i" un indice de tableau.
 // Strategie: mettre une carte sur deux du tableau "j" dans le tas "t1" et
 //            les autres dans le tas "t2".
 //
 protected static void distribuerCartes(Carte j[], Tas t1, Tas t2) {
  int i = 0;
 
  while (i < 16) {
   t1.mettre(j[2 * i]);
   t2.mettre(j[2 * i + 1]);
   i++;
  }  
 }
 //----------------------------------------------------------------DeplacerCarte
 // Entrees: deux tas "t1" et "t2".
 // Finalite: prendre une carte au sommet du tas "t2" et la placer sous le
 //           tas "t1".
 // Variables inter: "c" une carte.
 //
 protected static void deplacerCarte(Tas t1, Tas t2) {
  Carte c;

  if (!t2.vide()) {
   c = t2.retirer();
   t1.mettre(c);
  }
 }
 //------------------------------------------------------------------DeplacerTas
 // Entrees: deux tas "t1" et "t2".
 // Finalite: placer le tas "t2" sous le tas "t1".
 // Variables inter: "c" une carte.
 // Strategie: tant que le tas "t2" n'est pas vide, deplace la carte au sommet
 //            de "t2" sous le tas "t1".
 //
 protected static void deplacerTas(Tas t1, Tas t2)
 { while (!t2.vide()) deplacerCarte(t1,t2); }
 //------------------------------------------------------------------AfficherTas
 // Entrees: trois tas "t1", "t2" et "ta".
 // Finalite: afficher le contenu des trois tas du jeu de la bataille (le tas
 //           du joueur 1, celui du joueur 2 et le tas d'attente).
 //
 protected static void afficherTas(Tas t1,Tas t2,Tas ta) {
  String c;

  Ecran.ecrire("Tas 1 = ");
  t1.afficher();
  Ecran.ecrire("\nTas 2 = ");
  t2.afficher();
  Ecran.ecrire("\nAttente = ");
  ta.afficher();

  c = Clavier.lireChaine(); 
 }
 //----------------------------------------------------------------------Simuler
 // Entrees: deux tas "t1" et "t2".
 // Finalite: simuler le deroulement d'une partie du jeu de la bataille d'apres
 //           les regles enoncees.
 // Hypotheses: "t1" et "t2" contiennent chacun 16 cartes.
 // Variables inter: "c1" et "c2" les deux cartes en bataille a chaque tour,
 //                  "ta" le tas utilise pour placer les cartes en attente
 //                  lors d'une egalite.
 // Strategie: cf. les regles.
 //
 protected static void simuler(Tas t1,Tas t2) {
  Carte c1;
  Carte c2;
  Tas ta = new Tas();

  afficherTas(t1,t2,ta);

  while (!t1.vide() && !t2.vide()) {
   c1 = t1.retirer();
   c2 = t2.retirer();

   if (c1.puissance > c2.puissance) {
    Ecran.ecrire("Joueur 1 gagne !\n\n");
    deplacerTas(t1,ta);
    t1.mettre(c1);
    t1.mettre(c2);
   }
   else if (c1.puissance < c2.puissance) {
    Ecran.ecrire("Joueur 2 gagne !\n\n");
    deplacerTas(t2,ta);
    t2.mettre(c2);
    t2.mettre(c1);
   }
   else {
    Ecran.ecrire("Egalite !\n\n");
    ta.mettre(c1);
    ta.mettre(c2);
    deplacerCarte(ta,t1);
    deplacerCarte(ta,t2);
   }

   afficherTas(t1,t2,ta);
  }
 }
 //-------------------------------------------------------------------------Main
 public static void main(String args[]) {
  Carte j[] = new Carte[32];
  Tas t1 = new Tas();
  Tas t2 = new Tas();
 
  creerJeu(j);
  melangerJeu(j);
  distribuerCartes(j,t1,t2);
  simuler(t1,t2);

  if (t1.vide()) Ecran.ecrire("Joueur 2 a gagne !\n");
  else Ecran.ecrire("Joueur 1 a gagne !\n");
 }
}

// Fin //-----------------------------------------------------------------------
