//==============================================================================
// T P 5                                                                 Classe
// T a s
//==============================================================================

// Cette classe represente un tas de cartes.

// Package //-------------------------------------------------------------------
package tp5;

// Importation //---------------------------------------------------------------
import entreeSortie.*;

// Classe  T a s //-------------------------------------------------------------
public class Tas {
 //--------------------------------------------------------------------Attributs
 protected Maillon tete;
 protected Maillon fin;
 //-----------------------------------------------------------------Constructeur
 // Finalite: construire et initialiser un tas de cartes.
 //
 public Tas() {
  tete = null;
  fin = null;
 }
 //-------------------------------------------------------------------------Vide
 // Finalite: indiquer si le tas est vide.
 // Sortie: renvoie "VRAI" si le tas est vide.
 //
 public boolean vide() { return (tete == null); }
 //-----------------------------------------------------------------------Mettre
 // Entrees: une carte "c".
 // Finalite: mettre la carte "c" sous le tas.
 // Variables inter: "m" le nouveau maillon.
 // Strategie: ajouter "c" a la fin de la liste.
 //
 public void mettre(Carte c) {
  Maillon m = new Maillon();
  
  if (m == null) {
   Ecran.ecrire("Pas assez de memoire.\n");
   System.exit(1);
  }

  m.carte = c;
  m.suiv = null; 

  if (fin == null) tete = m;
  else fin.suiv = m;
 
  fin = m;
 }
 //----------------------------------------------------------------------Retirer
 // Finalite: retirer la carte au dessus du tas et la retourner.
 // Sortie: la carte du dessus.
 // Variables inter: "c" la carte du dessus.
 // Strategie: retirer la tete de la liste.
 //
 public Carte retirer() {
  Carte c = tete.carte;
  tete = tete.suiv;
  if (tete == null) fin = null;
  return c;
 }
 //---------------------------------------------------------------------Afficher
 // Finalite: afficher les cartes contenues dans le tas.
 // Variables inter: "m" un maillon pour parcourir la liste.
 // Strategie: parcours la liste et a chaque carte rencontree, on 
 //            affiche sa valeur.
 //
 public void afficher() {
  Maillon m = tete;
  
  Ecran.ecrire("[ ");
 
  while (m != null) {
   m.carte.afficher();
   m = m.suiv;
  }

  Ecran.ecrire("]\n");
 }
}

// Classe  M a i l l o n //-----------------------------------------------------
class Maillon {
 //--------------------------------------------------------------------Attributs
 public Carte   carte;
 public Maillon suiv;
 //-----------------------------------------------------------------Constructeur
 // Finalite: construire et initialiser un maillon.
 //
 public Maillon() {
  carte = null;
  suiv = null;
 }
}

// Fin //-----------------------------------------------------------------------
