//==============================================================================
// E n t r e e S o r t i e                                               Classe
// C l a v i e r
//                                                           Par Bruno Bachelet
//==============================================================================
// Copyright (c) 1999-2016
// Bruno Bachelet - bruno@nawouak.net - http://www.nawouak.net
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the license, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details (http://www.gnu.org).

// Cette classe permet de recuperer des informations saisies au clavier.

// Package //-------------------------------------------------------------------
package entreeSortie;

// Importation //---------------------------------------------------------------
import java.io.*;

// Classe  C l a v i e r //-----------------------------------------------------
public class Clavier {
 //-------------------------------------------------------------------LireChaine
 // Retourne la chaine de caracteres saisie par l'utilisateur.
 public static String lireChaine() {
  BufferedReader buffer;

  try {
   buffer = new BufferedReader(new InputStreamReader(System.in));
   return (buffer.readLine());
  }

  catch(Exception exception) {}

  return (new String());
 }
 //-------------------------------------------------------------------LireEntier
 // Retourne le nombre entier saisi par l'utilisateur.
 public static int lireEntier() {
  StreamTokenizer flux;

  do {
   try {
    flux = new StreamTokenizer(new BufferedReader(
           new InputStreamReader(System.in)));

    if (flux.nextToken()==StreamTokenizer.TT_NUMBER) return ((int)flux.nval);
    else System.out.print("Entier SVP ! ");
   }

   catch(Exception e) { System.out.print("Entier SVP ! "); }
  }
  while (true);
 }
 //---------------------------------------------------------------------LireReel
 // Retourne le nombre reel saisi par l'utilisateur.
 public static double lireReel() {
  StreamTokenizer flux;

  do {
   try {
    flux = new StreamTokenizer(new BufferedReader(
           new InputStreamReader(System.in)));

    if (flux.nextToken()==StreamTokenizer.TT_NUMBER) return (flux.nval);
    else System.out.print("Reel SVP ! ");
   }

   catch(Exception e) { System.out.print("Reel SVP ! "); }
  }
  while (true);
 }
}

// Fin //-----------------------------------------------------------------------
