//==============================================================================
// E n t r e e S o r t i e                                               Classe
// F i c h i e r E n t r e e
//                                                           Par Bruno Bachelet
//==============================================================================
// Copyright (c) 1999-2016
// Bruno Bachelet - bruno@nawouak.net - http://www.nawouak.net
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the license, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details (http://www.gnu.org).

// Cette classe permet de lire dans un fichier en mode texte.

// Package //-------------------------------------------------------------------
package entreeSortie;

// Importation //---------------------------------------------------------------
import java.io.*;

// Classe  F i c h i e r E n t r e e //-----------------------------------------
public class FichierEntree {
 //--------------------------------------------------------------------Attributs
 private BufferedReader  fichier;
 private StreamTokenizer flux;
 //-----------------------------------------------------------------Constructeur
 // Ouvre un fichier en lecture.
 public FichierEntree(String nom) {
  try {
   fichier = new BufferedReader(new FileReader(nom));
   flux = new StreamTokenizer(fichier);
   flux.wordChars(33,255);
  }

  catch(Exception exception) {
   System.err.println("Erreur: Impossible d'ouvrir '"+nom+"'.");
   System.exit(1);
  }
 }
 //-----------------------------------------------------------------------Fermer
 // Ferme le fichier.
 public void fermer() {
  try {
   flux = null;
   fichier.close();
  }

  catch(Exception exception) {}
 }
 //-------------------------------------------------------------------LireChaine
 // Lit la chaine suivante dans le fichier.
 public String lireChaine() {
  try { if (flux.nextToken()==StreamTokenizer.TT_WORD) return (flux.sval); }

  catch(Exception exception) {
   System.err.println("Erreur: Impossible de lire une chaine dans le fichier.");
   System.exit(1);
  }

  return (new String());
 }
 //--------------------------------------------------------------------LireLigne
 // Lit la ligne suivante dans le fichier.
 public String lireLigne() {
  String ligne;

  try {
   do
    { ligne = fichier.readLine(); }
   while (ligne.equals(""));

   return ligne;
  }
  catch(Exception exception) {}

  return (new String());
 }
 //-------------------------------------------------------------------LireEntier
 // Lit l'entier suivant dans le fichier.
 public int lireEntier() {
  try {
   if (flux.nextToken()==StreamTokenizer.TT_NUMBER)
    return ((int)flux.nval);
  }

  catch(Exception exception) {
   System.err.println("Erreur: Impossible de lire un entier dans le fichier.");
   System.exit(1);
  }

  return 0;
 }
 //---------------------------------------------------------------------LireReel
 // Lit le reel suivant dans le fichier.
 public double lireReel() {
  try { if (flux.nextToken()==StreamTokenizer.TT_NUMBER) return (flux.nval); }

  catch(Exception exception) {
   System.err.println("Erreur: Impossible de lire un reel dans le fichier.");
   System.exit(1);
  }

  return 0.0;
 }
}

// Fin //-----------------------------------------------------------------------
