//==============================================================================
// E n t r e e S o r t i e                                               Classe
// F i c h i e r S o r t i e
//                                                           Par Bruno Bachelet
//==============================================================================
// Copyright (c) 1999-2016
// Bruno Bachelet - bruno@nawouak.net - http://www.nawouak.net
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the license, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details (http://www.gnu.org).

// Cette classe permet d'ecrire dans un fichier en mode texte.

// Package //-------------------------------------------------------------------
package entreeSortie;

// Importation //---------------------------------------------------------------
import java.io.*;

// Classe  F i c h i e r S o r t i e //-----------------------------------------
public class FichierSortie {
 //--------------------------------------------------------------------Attributs
 private BufferedWriter fichier;
 //-----------------------------------------------------------------Constructeur
 // Ouvre un fichier en mode ecriture.
 public FichierSortie(String nom) {
  try { fichier = new BufferedWriter(new FileWriter(nom)); }

  catch(Exception exception) {
   System.err.println("Erreur: Impossible d'ouvrir '"+nom+"'.");
   System.exit(1);
  }
 }
 //-----------------------------------------------------------------------Fermer
 // Ferme le fichier.
 public void fermer() {
  try { fichier.close(); }
  catch(Exception exception) {}
 }
 //--------------------------------------------------------------Ecrire (Chaine)
 // Ecrit la chaine dans le fichier.
 public void ecrire(String chaine) {
  try { fichier.write(chaine); }

  catch(Exception exception) {
   System.err.println("Erreur: Imposible d'ecrire la chaine dans le fichier.");
   System.exit(1);
  }
 }
 //--------------------------------------------------------------Ecrire (Entier)
 // Ecrit un entier dans le fichier.
 public void ecrire(int entier) {
  try { fichier.write(""+entier); }

  catch(Exception exception) {
   System.err.println("Erreur: Imposible d'ecrire l'entier dans le fichier.");
   System.exit(1);
  }
 }
 //----------------------------------------------------------------Ecrire (Reel)
 // Ecrit un reel dans le fichier.
 public void ecrire(double nombre) {
  try { fichier.write(""+nombre); }

  catch(Exception exception) {
   System.err.println("Erreur: Imposible d'ecrire le reel dans le fichier.");
   System.exit(1);
  }
 }
}

// Fin //-----------------------------------------------------------------------
