/*----------------------------------------------------------------------------*/
/* ARBRES BINAIRES                                                    ARBRE.H */
/*                                                         Par Bruno Bachelet */
/*----------------------------------------------------------------------------*/
/* Copyright (c) 1999-2016
   Bruno Bachelet - bruno@nawouak.net - http://www.nawouak.net

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the license, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details (http://www.gnu.org).
*/

/* Gardien -------------------------------------------------------------------*/
#ifndef ARBRE_H
#define ARBRE_H

/* Headers -------------------------------------------------------------------*/
#include "commun.h"

/* Types ---------------------------------------------------------------------*/

typedef struct _NOEUD_ {
 ELEMENT          elt;
 struct _NOEUD_ * fg;
 struct _NOEUD_ * fd;
 int              h;
} NOEUD;

typedef NOEUD * ARBRE;

/* Prototypes ----------------------------------------------------------------*/

/* 1 - Initialise un arbre. */
void initialiserArbre(ARBRE * a);

/* 2 - Prepare un noeud. */
NOEUD * preparerNoeud(ELEMENT e);

/* 3 - Ajoute un noeud dans un arbre. */
BOOLEEN ajouterNoeud(ARBRE * a, NOEUD * n);

/* 4 - Ajoute un element dans un arbre. */
BOOLEEN ajouterElement(ARBRE * a, ELEMENT e);

/* 5 - Indique si un element avec une cle donnee existe. */
BOOLEEN existeCle(ARBRE a, CLE c);

/* 6 - Extrait le noeud de cle maximum d'un arbre. */
NOEUD * extraireMaximum(ARBRE * a);

/* 7 - Supprime le noeud a la racine d'un arbre. */
BOOLEEN supprimerRacine(ARBRE * a);

/* 8 - Extrait l'element ayant une cle donnee d'un arbre. */
BOOLEEN extraireElement(ARBRE * a, CLE c, ELEMENT * e);

/* 9 - Met a jour la hauteur d'un noeud a partir des fils. */
void majHauteur(NOEUD * n);

/* 10 - Retourne la valeur du desequilibre d'un arbre. */
int desequilibre(ARBRE a);

/* 11 - Effectue une rotation RD. */
BOOLEEN rotationRD(ARBRE * a);

/* 12 - Effectue une rotation RG. */
BOOLEEN rotationRG(ARBRE * a);

/* 13 - Effectue une rotation RGD. */
BOOLEEN rotationRGD(ARBRE * a);

/* 14 - Effectue une rotation RDG. */
BOOLEEN rotationRDG(ARBRE * a);

/* 15 - Reequilibre un arbre. */
void reequilibrer(ARBRE * a);

/* Fin -----------------------------------------------------------------------*/
#endif
