/*----------------------------------------------------------------------------*/
/* ARBRES BINAIRES                                                 ARBRETST.C */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* TYPES */

typedef char ELEMENT;
typedef char CLE;

/*----------------------------------------------------------------------------*/
/* MACROS */
#define cle(e) (e)

/*----------------------------------------------------------------------------*/
/* HEADERS */
#include "arbre.c"

/*----------------------------------------------------------------------------*/
/* AFFICHER_ESPACE */
/* Affiche un nombre donne d'espaces a l'ecran. */

void afficherEspace(int n) {
 while (n > 0) {
  printf(" ");
  n--;
 }
}

/*----------------------------------------------------------------------------*/
/* AFFICHER_ARBRE */
/* Affiche le contenu d'un arbre. */

void afficherArbre(ARBRE a) {
 int largeur = 64; /* Largeur de l'ecran. */
 int pmax = 5; /* Profondeur affichee de l'arbre. */
 
 NOEUD ** t1 = ALLOUER(NOEUD *,32); /* Premier tableau. */
 NOEUD ** t2 = ALLOUER(NOEUD *,32); /* Deuxieme tableau. */
 NOEUD ** t3; /* Pointeur pour permuter "t1" et "t2". */                 

 int n1; /* Taille logique de "t1". */
 int n2; /* Taille logique de "t2". */
 
 int espace = largeur;
 int profondeur = 0;
 int i;
 
 t1[0] = a;
 n1 = 1;
 
 while (profondeur < pmax) {
  espace = espace / 2;
  afficherEspace(espace - 1);
  n2 = 0;
  i = 0;
  
  while (i < n1) {
   if (t1[i] == NULL) {
    printf(".");
    t2[n2++] = NULL;
    t2[n2++] = NULL;
   }
   else {
    printf("%c",t1[i]->elt);
    t2[n2++] = t1[i]->fg;
    t2[n2++] = t1[i]->fd;
   }
   
   i++;
   if (i < n1) afficherEspace(2 * espace - 1);
  }
  
  if (EQUILIBRAGE) {
   printf("\n");
   afficherEspace(espace - 2);
   i = 0;
  
   while (i < n1) {
    if (t1[i] == NULL) printf("  ");
    else {
     if (t1[i]->h >= 0) printf("+%d",t1[i]->h);
     else printf("%d",t1[i]->h);
    }
   
    i++;
    if (i < n1) afficherEspace(2 * espace - 2);
   }
  }
  
  printf("\n\n");
  t3 = t1;
  t1 = t2;
  t2 = t3;
  n1 = n2;
  profondeur++;
 } 
 
 LIBERER(t1);
 LIBERER(t2);
}

/*----------------------------------------------------------------------------*/
/* CHERCHER_NOEUD */
/* Cherche un noeud dans un arbre a partir de sa cle. */

ARBRE * chercherNoeud(ARBRE * a, CLE c) {
 if (*a == NULL) return NULL;
 if (c == cle((*a)->elt)) return a;
 if (c < cle((*a)->elt)) return chercherNoeud(&((*a)->fg),c);
 return chercherNoeud(&((*a)->fd),c);
}

/*----------------------------------------------------------------------------*/
/* TEST 1 */
/* Teste "ajouterElement". */

void test_1(ARBRE * a) {
 char e[50];

 printf("\n");
 printf("Cle ? ");
 scanf("%s",e);

 if (ajouterElement(a,e[0])) printf("Cle ajoutee.\n");
 else printf("Impossible d'ajouter la cle.\n");

 printf("\n");
}

/*----------------------------------------------------------------------------*/
/* TEST 2 */
/* Teste "extraireMaximum". */

void test_2(ARBRE * a) {
 NOEUD * n;
 
 printf("\n");
 n = extraireMaximum(a);
 
 if (n != NULL) {
  printf("Cle '%c' extraite.\n",n->elt);
  LIBERER(n);
 }
 else printf("Impossible d'extraire la cle maximum.\n");
 
 printf("\n");
}

/*----------------------------------------------------------------------------*/
/* TEST 3 */
/* Teste "supprimerRacine". */

void test_3(ARBRE * a) {
 printf("\n");

 if (supprimerRacine(a)) printf("Racine supprimee.\n");
 else printf("Impossible de supprimer la racine.\n"); 

 printf("\n");
}

/*----------------------------------------------------------------------------*/
/* TEST 4 */
/* Teste "extraireElement". */

void test_4(ARBRE * a) {
 char c;
 char e[50];

 printf("\n");
 printf("Cle ? ");
 scanf("%s",e);

 if (extraireElement(a,e[0],&c)) printf("Cle '%c' extraite.\n",c);
 else printf("Impossible d'extraire la cle.\n");

 printf("\n");
}

/*----------------------------------------------------------------------------*/
/* TEST 5 */
/* Teste "existeCle". */

void test_5(ARBRE a) {
 char e[50];

 printf("\n");
 printf("Cle ? ");
 scanf("%s",e);

 if (existeCle(a,e[0])) printf("La cle existe.\n");
 else printf("La cle n'existe pas.\n");

 printf("\n");
}

/*----------------------------------------------------------------------------*/
/* TEST 6 */
/* Teste "rotationRD". */

void test_6(ARBRE * a) {
 char e[50];
 NOEUD ** n;
 
 printf("\n");
 printf("Cle ? ");
 scanf("%s",e);
 n = chercherNoeud(a,e[0]);
 
 if (n != NULL) {
  if (rotationRD(n)) printf("Rotation RD sur '%c' effectuee.\n",e[0]);
 }
 else printf("La cle n'existe pas.\n");

 printf("\n");
}

/*----------------------------------------------------------------------------*/
/* TEST 7 */
/* Teste "rotationRG". */

void test_7(ARBRE * a) {
 char e[50];
 NOEUD ** n;
 
 printf("\n");
 printf("Cle ? ");
 scanf("%s",e);
 n = chercherNoeud(a,e[0]);
 
 if (n != NULL) {
  if (rotationRG(n)) printf("Rotation RG sur '%c' effectuee.\n",e[0]);
 }
 else printf("La cle n'existe pas.\n");

 printf("\n");
}

/*----------------------------------------------------------------------------*/
/* TEST 8 */
/* Teste "rotationRGD". */

void test_8(ARBRE * a) {
 char e[50];
 NOEUD ** n;
 
 printf("\n");
 printf("Cle ? ");
 scanf("%s",e);
 n = chercherNoeud(a,e[0]);
 
 if (n != NULL) {
  if (rotationRGD(n)) printf("Rotation RGD sur '%c' effectuee.\n",e[0]);
 }
 else printf("La cle n'existe pas.\n");

 printf("\n");
}

/*----------------------------------------------------------------------------*/
/* TEST 9 */
/* Teste "rotationRDG". */

void test_9(ARBRE * a) {
 char e[50];
 NOEUD ** n;
 
 printf("\n");
 printf("Cle ? ");
 scanf("%s",e);
 n = chercherNoeud(a,e[0]);
 
 if (n != NULL) {
  if (rotationRDG(n)) printf("Rotation RDG sur '%c' effectuee.\n",e[0]);
 }
 else printf("La cle n'existe pas.\n");

 printf("\n");
}

/*----------------------------------------------------------------------------*/
/* MAIN */

int main(void) {
 ARBRE a;
 char c[50];

 printf("Equilibrage [o/n] ? ");
 scanf("%s",c);
 if (c[0]=='o' || c[0]=='O') EQUILIBRAGE = VRAI;
 initialiserArbre(&a);

 do {
  afficherArbre(a);
  printf("\n");
  printf("1. Ajouter - ");
  printf("2. Extraire - ");
  printf("3. Chercher cle - ");

  if (!EQUILIBRAGE) {
   printf("4. Extraire maximum\n");
   printf("5. Supprimer racine - ");
   printf("6. Rotation RD - ");
   printf("7. Rotation RG - ");
   printf("8. Rotation RGD\n");
   printf("9. Rotation RDG - ");
  }
  
  printf("0. Quitter\n");
  
  printf("\n");
  printf("Choix ? ");
  scanf("%s",c);
  
  if (EQUILIBRAGE && c[0] >= '4' && c[0] <= '9') c[0] = '0';
  
  switch (c[0]) {
   case '1': /* Ajouter. */
    test_1(&a);
    break;
    
   case '2': /* Extraire. */
    test_4(&a);
    break;

   case '3': /* Chercher cle. */
    test_5(a);
    break;

   case '4': /* Extraire maximum. */
    test_2(&a);
    break;
    
   case '5': /* Supprimer racine. */
    test_3(&a);
    break;
    
   case '6': /* Rotation RD. */
    test_6(&a);
    break;
    
   case '7': /* Rotation RG. */
    test_7(&a);
    break;
    
   case '8': /* Rotation RGD. */
    test_8(&a);
    break;
    
   case '9': /* Rotation RDG. */
    test_9(&a);
    break;
    
   case '0': /* Fin. */
    break;

   default:
    printf("\n");
    printf("Choix incorrect !\n");
    printf("\n");
  }
 } 
 while (c[0] != '0');
 
 return 0;
}

/*----------------------------------------------------------------------------*/
/* FIN */
