/*----------------------------------------------------------------------------*/
/* FICHIER COMMUN                                                    COMMUN.H */
/*                                                         Par Bruno Bachelet */
/*----------------------------------------------------------------------------*/
/* Copyright (c) 1999-2016
   Bruno Bachelet - bruno@nawouak.net - http://www.nawouak.net

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the license, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details (http://www.gnu.org).
*/

/* gardien ------------------------------------------------------------------*/
#ifndef COMMUN_H
#define COMMUN_H

/* Headers -------------------------------------------------------------------*/
#include <stdio.h> /* Entrees/sorties: affichage, clavier, fichiers... */
#include <stdlib.h> /* Gestion dynamique de la memoire. */
#include <string.h> /* Manipulation des chaines de caracteres. */

/* Types ---------------------------------------------------------------------*/
typedef enum { FAUX = 0, VRAI = 1 } BOOLEEN; /* Type d'un booleen. */
typedef FILE * FICHIER; /* Type d'un fichier. */

/* Macros --------------------------------------------------------------------*/
#define ALLOUER(t,n) ((t *)malloc((n)*sizeof(t)))
/* Alloue "n" elements de type "t". */

#define LIBERER(p) (free(p))
/* Libere la memoire allouee a l'adresse "p". */

#define MAX(a,b) ((a) < (b) ? (b) : (a))
/* Retourne la plus grande des valeurs "a" et "b". */

/* Constantes ----------------------------------------------------------------*/
#define NMAX 20
/* Taille maximale d'un tableau. */

/* Fin -----------------------------------------------------------------------*/
#endif
